/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.report.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import org.unitils.mock.core.BehaviorDefiningInvocation;
import org.unitils.mock.core.ObservedInvocation;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.mockbehavior.MockBehavior;
import org.unitils.mock.mockbehavior.impl.DefaultValueReturningMockBehavior;
import org.unitils.mock.mockbehavior.impl.OriginalBehaviorInvokingMockBehavior;
import org.unitils.mock.report.impl.ObservedInvocationsReport;
import org.unitils.mock.report.impl.ProxyInvocationsReport;

public class DetailedObservedInvocationsReport
extends ObservedInvocationsReport {
    public DetailedObservedInvocationsReport(Object testedObject) {
        super(testedObject);
    }

    @Override
    public String createReport(List<ObservedInvocation> observedInvocations) {
        StringBuilder result = new StringBuilder();
        IdentityHashMap<Object, ProxyInvocationsReport.FormattedObject> allLargeObjects = new IdentityHashMap<Object, ProxyInvocationsReport.FormattedObject>();
        HashMap largeObjectNameIndexes = new HashMap();
        int invocationIndex = 1;
        for (ObservedInvocation observedInvocation : observedInvocations) {
            ArrayList<ProxyInvocationsReport.FormattedObject> currentLargeObjects = new ArrayList<ProxyInvocationsReport.FormattedObject>();
            result.append(invocationIndex++);
            result.append(". ");
            result.append(this.formatObservedInvocation(observedInvocation, currentLargeObjects, allLargeObjects, largeObjectNameIndexes));
            result.append("\n");
            result.append(this.formatLargeObjects(currentLargeObjects));
            result.append(this.formatInvokedAt(observedInvocation));
            result.append(this.formatBehaviorDetails(observedInvocation));
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    protected String formatInvokedAt(ProxyInvocation proxyInvocation) {
        StringBuilder result = new StringBuilder();
        result.append("- Observed at ");
        result.append(proxyInvocation.getInvokedAt());
        result.append("\n");
        return result.toString();
    }

    protected String formatBehaviorDetails(ObservedInvocation observedInvocation) {
        StringBuilder result = new StringBuilder();
        BehaviorDefiningInvocation behaviorDefiningInvocation = observedInvocation.getBehaviorDefiningInvocation();
        if (behaviorDefiningInvocation != null) {
            result.append("- Behavior defined at ");
            result.append(behaviorDefiningInvocation.getInvokedAt());
            result.append("\n");
            return result.toString();
        }
        MockBehavior mockBehavior = observedInvocation.getMockBehavior();
        if (mockBehavior != null) {
            if (mockBehavior instanceof OriginalBehaviorInvokingMockBehavior) {
                result.append("- No behavior defined, executed original method behavior.");
            } else if (mockBehavior instanceof DefaultValueReturningMockBehavior) {
                result.append("- No behavior defined, returned default value.");
            } else {
                result.append("- No behavior defined, executed default behavior.");
            }
            result.append("\n");
        }
        return result.toString();
    }

    protected String formatLargeObjects(List<ProxyInvocationsReport.FormattedObject> largeObjects) {
        StringBuilder result = new StringBuilder();
        ArrayList<String> usedNames = new ArrayList<String>();
        if (!largeObjects.isEmpty()) {
            for (ProxyInvocationsReport.FormattedObject largeObject : largeObjects) {
                String name = largeObject.getName();
                if (usedNames.contains(name)) continue;
                usedNames.add(name);
                String representation = largeObject.getRepresentation();
                result.append("- ");
                result.append(name);
                result.append(" -> ");
                result.append(representation);
                result.append("\n");
            }
        }
        return result.toString();
    }
}

