/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.mockbehavior.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitils.core.UnitilsException;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.mockbehavior.ValidatableMockBehavior;

public class DefaultValueReturningMockBehavior
implements ValidatableMockBehavior {
    @Override
    public void assertCanExecute(ProxyInvocation proxyInvocation) throws UnitilsException {
        Class<?> returnType = proxyInvocation.getMethod().getReturnType();
        if (returnType == Void.TYPE) {
            throw new UnitilsException("Trying to define mock behavior that returns a value for a void method.");
        }
    }

    @Override
    public Object execute(ProxyInvocation proxyInvocation) {
        Class<?> returnType = proxyInvocation.getMethod().getReturnType();
        if (returnType == Void.TYPE) {
            return null;
        }
        if (Boolean.class.equals(returnType) || Boolean.TYPE.equals(returnType)) {
            return false;
        }
        if (returnType.isPrimitive() || Number.class.isAssignableFrom(returnType)) {
            return this.resolveNumber(returnType);
        }
        if (List.class.equals(returnType)) {
            return new ArrayList();
        }
        if (Set.class.equals(returnType)) {
            return new TreeSet();
        }
        if (Map.class.equals(returnType)) {
            return new HashMap();
        }
        if (Collection.class.equals(returnType)) {
            return new ArrayList();
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        return null;
    }

    protected Number resolveNumber(Class<?> numberType) {
        if (Integer.class.equals(numberType) || Integer.TYPE.equals(numberType)) {
            return 0;
        }
        if (Short.class.equals(numberType) || Short.TYPE.equals(numberType)) {
            return (short)0;
        }
        if (BigInteger.class.isAssignableFrom(numberType)) {
            return BigInteger.ZERO;
        }
        if (Long.class.equals(numberType) || Long.TYPE.equals(numberType)) {
            return 0L;
        }
        if (BigDecimal.class.isAssignableFrom(numberType)) {
            return BigDecimal.ZERO;
        }
        if (Double.class.equals(numberType) || Double.TYPE.equals(numberType)) {
            return 0.0;
        }
        if (Byte.class.equals(numberType) || Byte.TYPE.equals(numberType)) {
            return (byte)0;
        }
        if (Float.class.equals(numberType) || Float.TYPE.equals(numberType)) {
            return Float.valueOf(0.0f);
        }
        return 0;
    }
}

