/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAResource;
import org.tranql.connector.AbstractManagedConnection;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.AutocommitSpecCompliant;
import org.tranql.connector.jdbc.ConnectionHandle;

public class ManagedPooledConnection
extends AbstractManagedConnection<Connection, ConnectionHandle> {
    private final CredentialExtractor credentialExtractor;
    private final AbstractManagedConnection.LocalTransactionImpl localTx;
    private final AbstractManagedConnection.LocalTransactionImpl localClientTx;
    private final PooledConnection pooledConnection;

    public ManagedPooledConnection(ManagedConnectionFactory mcf, PooledConnection pooledConnection, CredentialExtractor credentialExtractor, ExceptionSorter exceptionSorter) throws SQLException {
        super(mcf, pooledConnection.getConnection(), exceptionSorter);
        this.pooledConnection = pooledConnection;
        pooledConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent event) {
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent event) {
                SQLException e = event.getSQLException();
                ManagedPooledConnection.this.unfilteredConnectionError(e);
            }
        });
        this.credentialExtractor = credentialExtractor;
        this.localTx = new AbstractManagedConnection.LocalTransactionImpl(true);
        this.localClientTx = new AbstractManagedConnection.LocalTransactionImpl(false);
    }

    @Override
    public boolean matches(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceAdapterInternalException {
        return this.credentialExtractor.matches(subject, connectionRequestInfo, (UserPasswordManagedConnectionFactory)mcf);
    }

    @Override
    public LocalTransaction getClientLocalTransaction() {
        return this.localClientTx;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTx;
    }

    @Override
    protected void localTransactionStart(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            c.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to disable autoCommit", (Throwable)e);
        }
        super.localTransactionStart(isSPI);
    }

    @Override
    protected void localTransactionCommit(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            if (this.mcf instanceof AutocommitSpecCompliant && ((AutocommitSpecCompliant)this.mcf).isCommitBeforeAutocommit() != null && ((AutocommitSpecCompliant)this.mcf).isCommitBeforeAutocommit().booleanValue()) {
                c.commit();
            }
            c.setAutoCommit(true);
        }
        catch (SQLException e) {
            block5: {
                try {
                    c.rollback();
                }
                catch (SQLException e1) {
                    if (this.log == null) break block5;
                    e.printStackTrace(this.log);
                }
            }
            throw new LocalTransactionException("Unable to commit", (Throwable)e);
        }
        super.localTransactionCommit(isSPI);
    }

    @Override
    protected void localTransactionRollback(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            c.rollback();
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to rollback", (Throwable)e);
        }
        super.localTransactionRollback(isSPI);
        try {
            c.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to enable autoCommit after rollback", (Throwable)e);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("XAResource not available from a LocalTransaction connection");
    }

    @Override
    public void cleanup() throws ResourceException {
        super.cleanup();
        Connection c = (Connection)this.physicalConnection;
        try {
            if (!c.getAutoCommit()) {
                c.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ResourceException("Could not reset autocommit when returning to pool", (Throwable)e);
        }
    }

    @Override
    protected void closePhysicalConnection() throws ResourceException {
        try {
            this.pooledConnection.close();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Error attempting to destroy managed connection", (Throwable)e);
        }
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }
}

