/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.layout;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.torquebox.mojo.rubygems.DependencyFile;
import org.torquebox.mojo.rubygems.DependencyHelper;
import org.torquebox.mojo.rubygems.GemFile;
import org.torquebox.mojo.rubygems.GemspecFile;
import org.torquebox.mojo.rubygems.GemspecHelper;
import org.torquebox.mojo.rubygems.IOUtil;
import org.torquebox.mojo.rubygems.RubygemsGateway;
import org.torquebox.mojo.rubygems.SpecsHelper;
import org.torquebox.mojo.rubygems.SpecsIndexFile;
import org.torquebox.mojo.rubygems.SpecsIndexType;
import org.torquebox.mojo.rubygems.SpecsIndexZippedFile;
import org.torquebox.mojo.rubygems.layout.GETLayout;
import org.torquebox.mojo.rubygems.layout.Storage;

public class HostedGETLayout
extends GETLayout {
    public HostedGETLayout(RubygemsGateway gateway, Storage store) {
        super(gateway, store);
    }

    @Override
    protected void retrieveZipped(SpecsIndexZippedFile specs) {
        super.retrieveZipped(specs);
        if (specs.notExists()) {
            try (ByteArrayInputStream content = this.gateway.newSpecsHelper().createEmptySpecs();){
                this.store.update(IOUtil.toGzipped(content), specs);
                this.store.retrieve(specs);
            }
            catch (IOException e) {
                specs.setException(e);
            }
        }
    }

    @Override
    public GemspecFile gemspecFile(String name, String version, String platform) {
        GemspecFile gemspec = super.gemspecFile(name, version, platform);
        if (gemspec.notExists()) {
            this.createGemspec(gemspec);
        }
        return gemspec;
    }

    @Override
    public GemspecFile gemspecFile(String filename) {
        GemspecFile gemspec = super.gemspecFile(filename);
        if (gemspec.notExists()) {
            this.createGemspec(gemspec);
        }
        return gemspec;
    }

    protected void createGemspec(GemspecFile gemspec) {
        GemFile gem = gemspec.gem();
        if (gem.notExists()) {
            gemspec.markAsNotExists();
        } else {
            try (InputStream is = this.store.getInputStream(gemspec.gem());){
                GemspecHelper spec = this.gateway.newGemspecHelperFromGem(is);
                this.store.update(spec.getRzInputStream(), gemspec);
                this.store.retrieve(gemspec);
            }
            catch (IOException e) {
                gemspec.setException(e);
            }
        }
    }

    @Override
    public DependencyFile dependencyFile(String name) {
        DependencyFile file = super.dependencyFile(name);
        this.store.retrieve(file);
        if (file.notExists()) {
            this.createDependency(file);
        }
        return file;
    }

    protected void createDependency(DependencyFile file) {
        try {
            List<String> versions;
            SpecsIndexFile specs = this.specsIndexFile(SpecsIndexType.RELEASE);
            this.store.retrieve(specs);
            if (specs.hasException()) {
                file.setException(specs.getException());
                return;
            }
            SpecsHelper specsHelper = this.gateway.newSpecsHelper();
            InputStream is = this.store.getInputStream(specs);
            Object object = null;
            try {
                versions = specsHelper.listAllVersions(file.name(), is);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            specs = this.specsIndexFile(SpecsIndexType.PRERELEASE);
            this.store.retrieve(specs);
            is = this.store.getInputStream(specs);
            object = null;
            try {
                versions.addAll(specsHelper.listAllVersions(file.name(), is));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            DependencyHelper gemspecs = this.gateway.newDependencyHelper();
            for (String version : versions) {
                GemspecFile gemspec = this.gemspecFile(file.name() + "-" + version.replaceFirst("-ruby$", ""));
                InputStream is2 = this.store.getInputStream(gemspec);
                Throwable throwable = null;
                try {
                    gemspecs.addGemspec(is2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is2 == null) continue;
                    if (throwable != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is2.close();
                }
            }
            try (ByteArrayInputStream is3 = gemspecs.getInputStream(false);){
                this.store.update(is3, file);
            }
            this.store.retrieve(file);
        }
        catch (IOException e) {
            file.setException(e);
        }
    }
}

