/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.layout;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.torquebox.mojo.rubygems.BundlerApiFile;
import org.torquebox.mojo.rubygems.DependencyFile;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.SpecsIndexZippedFile;
import org.torquebox.mojo.rubygems.layout.ProxyStorage;
import org.torquebox.mojo.rubygems.layout.SimpleStorage;

public class CachingProxyStorage
extends SimpleStorage
implements ProxyStorage {
    private final ConcurrentMap<String, Lock> locks = new ConcurrentSkipListMap<String, Lock>();
    protected final String baseurl;
    private final long ttl;
    private final int timeout;

    public CachingProxyStorage(File basedir, URL baseurl) {
        this(basedir, baseurl, 3600000L);
    }

    public CachingProxyStorage(File basedir, URL baseurl, long timeToLiveOfVolatileFiles) {
        super(basedir);
        this.baseurl = baseurl.toExternalForm().replaceFirst("/$", "");
        this.ttl = timeToLiveOfVolatileFiles;
        this.timeout = 60000;
    }

    @Override
    public boolean isExpired(DependencyFile file) {
        Path path = this.toPath(file);
        if (Files.notExists(path, new LinkOption[0])) {
            return true;
        }
        try {
            long mod = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            long now = System.currentTimeMillis();
            return now - mod > this.ttl;
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public void retrieve(BundlerApiFile file) {
        try {
            file.set(this.toUrl(file));
        }
        catch (IOException e) {
            file.setException(e);
        }
    }

    @Override
    public void retrieve(DependencyFile file) {
        this.retrieveVolatile(file);
    }

    @Override
    public void retrieve(SpecsIndexZippedFile file) {
        this.retrieveVolatile(file);
    }

    @Override
    public void retrieve(RubygemsFile file) {
        super.retrieve(file);
        if (file.notExists()) {
            this.download(file);
        }
    }

    private void download(RubygemsFile file) {
        try {
            URLConnection url = this.toUrl(file).openConnection();
            this.create(url.getInputStream(), file);
            if (file.hasPayload()) {
                this.setLastModified(this.toPath(file), url);
                file.resetState();
                super.retrieve(file);
            }
        }
        catch (FileNotFoundException e) {
            file.markAsNotExists();
        }
        catch (IOException e) {
            file.setException(e);
        }
    }

    protected boolean retrieveVolatile(RubygemsFile file) {
        Path path = this.toPath(file);
        if (Files.notExists(path, new LinkOption[0])) {
            this.download(file);
            return file.hasPayload();
        }
        try {
            long mod = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            long now = System.currentTimeMillis();
            if (now - mod > this.ttl) {
                this.update(file, path);
            } else {
                this.retrieve(file);
            }
        }
        catch (IOException e) {
            file.setException(e);
        }
        return file.hasPayload();
    }

    private Lock lock(RubygemsFile file) {
        ReentrantLock l = new ReentrantLock();
        Lock ll = this.locks.putIfAbsent(file.remotePath(), l);
        return ll == null ? l : ll;
    }

    private void unlock(RubygemsFile file) {
        Lock l = (Lock)this.locks.remove(file.remotePath());
        if (l != null) {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(RubygemsFile file, Path path) {
        Lock lock = this.lock(file);
        if (lock.tryLock()) {
            try {
                URLConnection url = this.toUrl(file).openConnection();
                this.update(url.getInputStream(), file);
                this.setLastModified(path, url);
            }
            catch (IOException e) {
                file.setException(e);
            }
            finally {
                this.unlock(file);
            }
        } else {
            try {
                if (!lock.tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                    file.markAsTempUnavailable();
                } else {
                    lock.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void setLastModified(Path path, URLConnection url) throws IOException {
        long mod = url.getLastModified();
        if (mod == 0L) {
            mod = System.currentTimeMillis();
        }
        Files.setLastModifiedTime(path, FileTime.fromMillis(mod));
    }

    protected SimpleStorage.URLStreamLocation toUrl(RubygemsFile file) throws MalformedURLException {
        return new SimpleStorage.URLStreamLocation(new URL(this.baseurl + file.remotePath()));
    }

    @Override
    public void expireNow(RubygemsFile file) {
        this.toPath(file).toFile().setLastModified(0L);
    }
}

