/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

import org.torquebox.mojo.rubygems.AbstractMetadataBuilder;
import org.torquebox.mojo.rubygems.DependencyData;

public class MetadataBuilder
extends AbstractMetadataBuilder {
    private final StringBuilder xml;
    private boolean closed = false;
    private final DependencyData deps;

    public MetadataBuilder(DependencyData deps) {
        super(deps.modified());
        this.deps = deps;
        this.xml = new StringBuilder();
        this.xml.append("<metadata>\n");
        this.xml.append("  <groupId>rubygems</groupId>\n");
        this.xml.append("  <artifactId>").append(deps.name()).append("</artifactId>\n");
        this.xml.append("  <versioning>\n");
        this.xml.append("    <versions>\n");
    }

    public void appendVersions(boolean isPrerelease) {
        for (String version : this.deps.versions(isPrerelease)) {
            this.xml.append("      <version>").append(version);
            if (isPrerelease) {
                this.xml.append("-SNAPSHOT");
            }
            this.xml.append("</version>\n");
        }
    }

    public void close() {
        if (!this.closed) {
            this.xml.append("    </versions>\n");
            this.xml.append("    <lastUpdated>").append(this.timestamp).append("</lastUpdated>\n");
            this.xml.append("  </versioning>\n");
            this.xml.append("</metadata>\n");
            this.closed = true;
        }
    }

    public String toString() {
        this.close();
        return this.xml.toString();
    }
}

