/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.hash;

import java.io.IOException;
import java.io.InputStream;
import org.tomitribe.util.hash.JvmUtils;
import org.tomitribe.util.hash.Preconditions;
import org.tomitribe.util.hash.Slice;
import org.tomitribe.util.hash.Slices;
import sun.misc.Unsafe;

public class XxHash32 {
    private static final int PRIME32_1 = 506952113;
    private static final int PRIME32_2 = 99338871;
    private static final int PRIME32_3 = 1119006269;
    private static final int PRIME32_4 = 668265263;
    private static final int PRIME32_5 = 374761393;
    private static final int DEFAULT_SEED = 0;
    private final int seed;
    private static final long BUFFER_ADDRESS = Unsafe.ARRAY_BYTE_BASE_OFFSET;
    private final byte[] buffer = new byte[16];
    private int bufferSize;
    private long bodyLength;
    private int v1;
    private int v2;
    private int v3;
    private int v4;

    public XxHash32() {
        this(0);
    }

    public XxHash32(int seed) {
        this.seed = seed;
        this.v1 = seed + 506952113 + 99338871;
        this.v2 = seed + 99338871;
        this.v3 = seed;
        this.v4 = seed - 506952113;
    }

    public XxHash32 update(byte[] data) {
        return this.update(data, 0, data.length);
    }

    public XxHash32 update(byte[] data, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, data.length);
        this.updateHash(data, Unsafe.ARRAY_BYTE_BASE_OFFSET + offset, length);
        return this;
    }

    public XxHash32 update(Slice data) {
        return this.update(data, 0, data.length());
    }

    public XxHash32 update(Slice data, int offset, int length) {
        Preconditions.checkPositionIndexes(0, offset + length, data.length());
        this.updateHash(data.getBase(), data.getAddress() + (long)offset, length);
        return this;
    }

    public int hash() {
        int hash = this.bodyLength > 0L ? this.computeBody() : this.seed + 374761393;
        hash = (int)((long)hash + (this.bodyLength + (long)this.bufferSize));
        return XxHash32.updateTail(hash, this.buffer, BUFFER_ADDRESS, 0, this.bufferSize);
    }

    private int computeBody() {
        return Integer.rotateLeft(this.v1, 1) + Integer.rotateLeft(this.v2, 7) + Integer.rotateLeft(this.v3, 12) + Integer.rotateLeft(this.v4, 18);
    }

    private void updateHash(Object base, long address, int length) {
        if (this.bufferSize > 0) {
            int available = Math.min(16 - this.bufferSize, length);
            JvmUtils.unsafe.copyMemory(base, address, this.buffer, BUFFER_ADDRESS + (long)this.bufferSize, available);
            this.bufferSize += available;
            address += (long)available;
            length -= available;
            if (this.bufferSize == 16) {
                this.updateBody(this.buffer, BUFFER_ADDRESS, this.bufferSize);
                this.bufferSize = 0;
            }
        }
        if (length >= 16) {
            int index = this.updateBody(base, address, length);
            address += (long)index;
            length -= index;
        }
        if (length > 0) {
            JvmUtils.unsafe.copyMemory(base, address, this.buffer, BUFFER_ADDRESS, length);
            this.bufferSize = length;
        }
    }

    private int updateBody(Object base, long address, int length) {
        int remaining;
        for (remaining = length; remaining >= 16; remaining -= 16) {
            this.v1 = XxHash32.mix(this.v1, JvmUtils.unsafe.getInt(base, address));
            this.v2 = XxHash32.mix(this.v2, JvmUtils.unsafe.getInt(base, address + 4L));
            this.v3 = XxHash32.mix(this.v3, JvmUtils.unsafe.getInt(base, address + 8L));
            this.v4 = XxHash32.mix(this.v4, JvmUtils.unsafe.getInt(base, address + 12L));
            address += 16L;
        }
        int index = length - remaining;
        this.bodyLength += (long)index;
        return index;
    }

    public static long hash(int value) {
        int hash = 374761397;
        hash = XxHash32.updateTail(hash, value);
        hash = XxHash32.finalShuffle(hash);
        return hash;
    }

    public static int hash(String data) {
        return XxHash32.hash(Slices.utf8Slice(data));
    }

    public static int hash(InputStream in) throws IOException {
        return XxHash32.hash(0, in);
    }

    public static int hash(int seed, InputStream in) throws IOException {
        int length;
        XxHash32 hash = new XxHash32(seed);
        byte[] buffer = new byte[8192];
        while ((length = in.read(buffer)) != -1) {
            hash.update(buffer, 0, length);
        }
        return hash.hash();
    }

    public static int hash(Slice data) {
        return XxHash32.hash(data, 0, data.length());
    }

    public static int hash(int seed, Slice data) {
        return XxHash32.hash(seed, data, 0, data.length());
    }

    public static int hash(Slice data, int offset, int length) {
        return XxHash32.hash(0, data, offset, length);
    }

    public static int hash(int seed, Slice data, int offset, int length) {
        Preconditions.checkPositionIndexes(0, offset + length, data.length());
        Object base = data.getBase();
        long address = data.getAddress() + (long)offset;
        int hash = length >= 16 ? XxHash32.updateBody(seed, base, address, length) : seed + 374761393;
        int index = length & 0xFFFFFFF0;
        return XxHash32.updateTail(hash += length, base, address, index, length);
    }

    private static int updateTail(int hash, Object base, long address, int index, int length) {
        if (index <= length - 4) {
            hash = XxHash32.updateTail(hash, JvmUtils.unsafe.getInt(base, address + (long)index));
            index += 4;
        }
        while (index < length) {
            hash = XxHash32.updateTail(hash, JvmUtils.unsafe.getByte(base, address + (long)index));
            ++index;
        }
        hash = XxHash32.finalShuffle(hash);
        return hash;
    }

    private static int updateBody(int seed, Object base, long address, int length) {
        int v1 = seed + 506952113 + 99338871;
        int v2 = seed + 99338871;
        int v3 = seed;
        int v4 = seed - 506952113;
        for (int remaining = length; remaining >= 16; remaining -= 16) {
            v1 = XxHash32.mix(v1, JvmUtils.unsafe.getInt(base, address));
            v2 = XxHash32.mix(v2, JvmUtils.unsafe.getInt(base, address + 4L));
            v3 = XxHash32.mix(v3, JvmUtils.unsafe.getInt(base, address + 8L));
            v4 = XxHash32.mix(v4, JvmUtils.unsafe.getInt(base, address + 12L));
            address += 16L;
        }
        return Integer.rotateLeft(v1, 1) + Integer.rotateLeft(v2, 7) + Integer.rotateLeft(v3, 12) + Integer.rotateLeft(v4, 18);
    }

    private static int mix(int current, int value) {
        return Integer.rotateLeft(current + value * 99338871, 13) * 506952113;
    }

    private static int update(int hash, int value) {
        int temp = hash + XxHash32.mix(0, value);
        return temp * 506952113 + 668265263;
    }

    private static int updateTail(int hash, int value) {
        int temp = hash + value * 1119006269;
        return Integer.rotateLeft(temp, 17) * 668265263;
    }

    private static int updateTail(int hash, byte value) {
        int unsigned = value & 0xFF;
        int temp = hash;
        return Integer.rotateLeft(temp += unsigned * 374761393, 11) * 506952113;
    }

    private static int finalShuffle(int hash) {
        hash ^= hash >>> 15;
        hash *= 99338871;
        hash ^= hash >>> 13;
        hash *= 1119006269;
        hash ^= hash >>> 16;
        return hash;
    }
}

