/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.dir;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.tomitribe.util.Files;
import org.tomitribe.util.dir.Filter;
import org.tomitribe.util.dir.Filters;
import org.tomitribe.util.dir.Mkdir;
import org.tomitribe.util.dir.Mkdirs;
import org.tomitribe.util.dir.Name;
import org.tomitribe.util.dir.Walk;
import org.tomitribe.util.reflect.Generics;

public interface Dir {
    public File dir();

    public Dir dir(String var1);

    public File mkdir();

    public File mkdirs();

    public File get();

    public File parent();

    public File file();

    public File file(String var1);

    public Stream<File> walk();

    public Stream<File> walk(int var1);

    public Stream<File> files();

    public Stream<File> files(int var1);

    public void delete();

    public static <T> T of(Class<T> clazz, File file) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new DirHandler(file));
    }

    public static class MkdirsFailedException
    extends RuntimeException {
        public MkdirsFailedException(Method method, File dir, Throwable t) {
            super(String.format("@Mkdirs failed%n method: %s%n path: %s", method, dir.getAbsolutePath()), t);
        }
    }

    public static class MkdirFailedException
    extends RuntimeException {
        public MkdirFailedException(Method method, File dir, Throwable t) {
            super(String.format("@Mkdir failed%n method: %s%n path: %s", method, dir.getAbsolutePath()), t);
        }
    }

    public static class DirHandler
    implements InvocationHandler {
        private final File dir;

        public DirHandler(File dir) {
            this.dir = dir;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.isDefault()) {
                return DirHandler.invokeDefault(proxy, method, args);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                if (method.getName().equals("toString")) {
                    return this.toString();
                }
                if (method.getName().equals("equals")) {
                    return this.equals(proxy, args);
                }
                if (method.getName().equals("hashCode")) {
                    return this.hashCode();
                }
            }
            if (method.getDeclaringClass().equals(Dir.class)) {
                if (method.getName().equals("dir")) {
                    return this.dir(args);
                }
                if (method.getName().equals("get")) {
                    return this.dir;
                }
                if (method.getName().equals("parent")) {
                    return this.dir.getParentFile();
                }
                if (method.getName().equals("mkdir")) {
                    return this.mkdir();
                }
                if (method.getName().equals("mkdirs")) {
                    return this.mkdirs();
                }
                if (method.getName().equals("delete")) {
                    return this.delete();
                }
                if (method.getName().equals("file")) {
                    return this.file(args);
                }
                if (method.getName().equals("walk")) {
                    return this.walk(args);
                }
                if (method.getName().equals("files")) {
                    return this.walk(args).filter(File::isFile);
                }
                throw new IllegalStateException("Unknown method " + method);
            }
            File file = new File(this.dir, this.name(method));
            Function<File, File> action = this.action(method);
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray()) {
                return this.returnArray(method);
            }
            if (Stream.class.equals(returnType) && args == null) {
                return this.returnStream(method);
            }
            if (File.class.equals(returnType) && args == null) {
                return this.returnFile(method, action.apply(file));
            }
            if (returnType.isInterface() && args != null && args.length == 1 && args[0] instanceof String) {
                return Dir.of(returnType, action.apply(new File(this.dir, (String)args[0])));
            }
            if (returnType.isInterface() && args == null) {
                return Dir.of(returnType, action.apply(file));
            }
            throw new UnsupportedOperationException(method.toGenericString());
        }

        private Object dir(Object[] args) {
            if (args == null || args.length == 0) {
                return this.dir;
            }
            return Dir.of(Dir.class, this.file(args));
        }

        private Stream<File> walk(Object[] args) {
            if (args == null || args.length == 0) {
                return DirHandler.walk(this.dir, -1, 0);
            }
            return DirHandler.walk(this.dir, (Integer)args[0], 0);
        }

        private boolean equals(Object proxy, Object[] args) {
            if (args.length != 1) {
                return false;
            }
            if (args[0] == null) {
                return false;
            }
            if (!proxy.getClass().isAssignableFrom(args[0].getClass())) {
                return false;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(args[0]);
            return this.equals(handler);
        }

        private File file(Object[] args) {
            if (args.length != 1) {
                throw new IllegalArgumentException("Expected String argument.  Found args length: " + args.length);
            }
            if (args[0] == null) {
                throw new IllegalArgumentException("Expected String argument.  Found null");
            }
            if (!String.class.equals(args[0].getClass())) {
                throw new IllegalArgumentException("Expected String argument.  Found " + args[0].getClass());
            }
            return new File(this.dir, args[0].toString());
        }

        private static Object invokeDefault(Object proxy, Method method, Object[] args) throws Throwable {
            float version = Float.parseFloat(System.getProperty("java.class.version"));
            if (version <= 52.0f) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                constructor.setAccessible(true);
                Class<?> clazz = method.getDeclaringClass();
                return ((MethodHandles.Lookup)constructor.newInstance(clazz)).in(clazz).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
            }
            return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
        }

        private Object returnStream(Method method) {
            Class returnType = (Class)Generics.getReturnType(method);
            Predicate<File> filter = this.getFilter(method);
            if (returnType.isInterface()) {
                return DirHandler.stream(this.dir, method).filter(filter).map(child -> Dir.of(returnType, child));
            }
            if (File.class.equals((Object)returnType)) {
                return DirHandler.stream(this.dir, method).filter(filter);
            }
            throw new UnsupportedOperationException(method.toGenericString());
        }

        private Object returnFile(Method method, File file) throws FileNotFoundException {
            if (this.exceptions(method).contains(FileNotFoundException.class) && !file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            return file;
        }

        private Object returnArray(Method method) {
            Predicate<File> filter = this.getFilter(method);
            Class<?> arrayType = method.getReturnType().getComponentType();
            if (File.class.equals(arrayType)) {
                return DirHandler.stream(this.dir, method).filter(filter).toArray(File[]::new);
            }
            if (arrayType.isInterface()) {
                Object[] src = DirHandler.stream(this.dir, method).filter(filter).map(child -> Dir.of(arrayType, child)).toArray();
                Object[] dest = (Object[])Array.newInstance(arrayType, src.length);
                System.arraycopy(src, 0, dest, 0, src.length);
                return dest;
            }
            throw new UnsupportedOperationException(method.toGenericString());
        }

        private static Stream<File> stream(File dir, Method method) {
            Walk walk = method.getAnnotation(Walk.class);
            if (walk != null) {
                return DirHandler.walk(walk, dir);
            }
            return Stream.of(dir.listFiles());
        }

        private static Stream<File> walk(Walk walk, File dir) {
            return DirHandler.walk(dir, walk.maxDepth(), walk.minDepth());
        }

        private static Stream<File> walk(File dir, int maxDepth, int minDepth) {
            Predicate<File> min = minDepth <= 0 ? file -> true : DirHandler.minDepth(dir, minDepth);
            try {
                if (maxDepth != -1) {
                    return java.nio.file.Files.walk(dir.toPath(), maxDepth, new FileVisitOption[0]).map(Path::toFile).filter(min);
                }
                return java.nio.file.Files.walk(dir.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(min);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private static Predicate<File> minDepth(File dir, int minDepth) {
            int parentDepth = DirHandler.getDepth(dir);
            return file -> {
                int fileDepth = DirHandler.getDepth(file);
                int depth = fileDepth - parentDepth;
                return depth >= minDepth;
            };
        }

        private static int getDepth(File dir) {
            int depth = 0;
            File f = dir;
            while (f != null) {
                f = f.getParentFile();
                ++depth;
            }
            return depth;
        }

        private Predicate<File> getFilter(Method method) {
            if (method.isAnnotationPresent(Filter.class)) {
                Filter filter = method.getAnnotation(Filter.class);
                return this.asPredicate(filter);
            }
            if (method.isAnnotationPresent(Filters.class)) {
                Filters filters = method.getAnnotation(Filters.class);
                Predicate<File> predicate = file -> true;
                for (Filter filter : filters.value()) {
                    predicate = predicate.and(this.asPredicate(filter));
                }
                return predicate;
            }
            return pathname -> true;
        }

        private Predicate<File> asPredicate(Filter filter) {
            if (filter == null) {
                return pathname -> true;
            }
            Class<? extends FileFilter> clazz = filter.value();
            try {
                FileFilter fileFilter = clazz.newInstance();
                return fileFilter::accept;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to instantiate filter " + clazz, e);
            }
        }

        private File mkdir() {
            Files.mkdir(this.dir);
            return this.dir;
        }

        private Void mkdirs() {
            Files.mkdirs(this.dir, new String[0]);
            return null;
        }

        private Void delete() {
            Files.remove(this.dir);
            return null;
        }

        private String name(Method method) {
            if (method.isAnnotationPresent(Name.class)) {
                return method.getAnnotation(Name.class).value();
            }
            return method.getName();
        }

        public List<Class<?>> exceptions(Method method) {
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            return Arrays.asList(exceptionTypes);
        }

        public Function<File, File> action(Method method) {
            if (method.isAnnotationPresent(Mkdir.class)) {
                return this.mkdir(method);
            }
            if (method.isAnnotationPresent(Mkdirs.class)) {
                return this.mkdirs(method);
            }
            return this.noop(method);
        }

        public Function<File, File> mkdir(Method method) {
            return file -> {
                try {
                    Files.mkdir(file);
                    return file;
                }
                catch (Exception e) {
                    throw new MkdirFailedException(method, (File)file, e);
                }
            };
        }

        public Function<File, File> mkdirs(Method method) {
            return file -> {
                try {
                    Files.mkdirs(file, new String[0]);
                    return file;
                }
                catch (Exception e) {
                    throw new MkdirsFailedException(method, (File)file, e);
                }
            };
        }

        public Function<File, File> noop(Method method) {
            return file -> file;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DirHandler that = (DirHandler)o;
            return this.dir.equals(that.dir);
        }

        public int hashCode() {
            return Objects.hash(this.dir);
        }

        public String toString() {
            return this.dir.getAbsolutePath();
        }
    }
}

