/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;

public class Zips {
    private Zips() {
    }

    public static void unzip(File zipFile, File destination) throws IOException {
        Zips.unzip(zipFile, destination, false);
    }

    public static void unzip(File zipFile, File destination, boolean noparent) throws IOException {
        Zips.unzip(zipFile, destination, noparent, false, (Filter)AcceptAll.INSTANCE);
    }

    public static void unzip(File zipFile, File destination, boolean noparent, boolean flatten, Filter filter) throws IOException {
        Files.dir(destination);
        Files.writable(destination);
        Files.file(zipFile);
        Files.readable(zipFile);
        try (InputStream read = IO.read(zipFile);){
            Zips.unzip(read, destination, noparent, flatten, filter);
        }
    }

    public static void unzip(InputStream read, File destination, boolean noparent) throws IOException {
        Zips.unzip(read, destination, noparent, false, (Filter)AcceptAll.INSTANCE);
    }

    public static void unzip(InputStream read, File destination, boolean noparent, boolean flatten, Filter filter) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream e = new ZipInputStream(read);
            while ((entry = e.getNextEntry()) != null) {
                String path = entry.getName();
                if (!filter.accept(path)) continue;
                if (noparent) {
                    path = path.replaceFirst("^[^/]+/", "");
                }
                if (flatten) {
                    path = path.substring(path.lastIndexOf("/"));
                }
                File file = new File(destination, path);
                if (entry.isDirectory()) {
                    Files.mkdirs(file, new String[0]);
                    continue;
                }
                Files.mkdirs(file.getParentFile(), new String[0]);
                IO.copy((InputStream)e, file);
                long lastModified = entry.getTime();
                if (lastModified <= 0L) continue;
                file.setLastModified(lastModified);
            }
        }
        catch (IOException var9) {
            throw new IOException("Unable to unzip " + read, var9);
        }
    }

    public static class KeepArchives
    implements Filter {
        public static final KeepArchives INSTANCE = new KeepArchives();

        @Override
        public boolean accept(String filename) {
            return filename != null && (filename.endsWith(".jar") || filename.endsWith(".war") || filename.endsWith(".ear") || filename.endsWith(".rar") || filename.endsWith(".zip"));
        }
    }

    public static class AcceptAll
    implements Filter {
        public static final AcceptAll INSTANCE = new AcceptAll();

        @Override
        public boolean accept(String filename) {
            return true;
        }
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

