/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.util.concurrent.TimeUnit;

public class TimeUtils {
    private TimeUtils() {
    }

    public static String formatMillis(long duration) {
        return TimeUtils.format(duration, TimeUnit.MILLISECONDS, TimeUtils.min(), TimeUtils.max());
    }

    public static String formatMillis(long duration, TimeUnit min, TimeUnit max) {
        return TimeUtils.format(duration, TimeUnit.MILLISECONDS, min, max);
    }

    public static String formatNanos(long duration, TimeUnit min, TimeUnit max) {
        return TimeUtils.format(duration, TimeUnit.NANOSECONDS, min, max);
    }

    public static String formatNanos(long duration, TimeUnit min) {
        return TimeUtils.format(duration, TimeUnit.NANOSECONDS, min, TimeUtils.max());
    }

    public static String format(long duration, TimeUnit sourceUnit, TimeUnit min) {
        return TimeUtils.format(duration, sourceUnit, min, TimeUtils.max());
    }

    public static String format(long duration, TimeUnit sourceUnit) {
        return TimeUtils.format(duration, sourceUnit, TimeUtils.min(), TimeUtils.max());
    }

    private static TimeUnit max() {
        TimeUnit[] values = TimeUnit.values();
        return values[values.length - 1];
    }

    private static TimeUnit min() {
        return TimeUnit.values()[0];
    }

    public static String abbreviateMillis(long duration) {
        return TimeUtils.abbreviate(duration, TimeUnit.MILLISECONDS, TimeUtils.min(), TimeUtils.max());
    }

    public static String abbreviateMillis(long duration, TimeUnit min, TimeUnit max) {
        return TimeUtils.abbreviate(duration, TimeUnit.MILLISECONDS, min, max);
    }

    public static String abbreviateNanos(long duration, TimeUnit min, TimeUnit max) {
        return TimeUtils.abbreviate(duration, TimeUnit.NANOSECONDS, min, max);
    }

    public static String abbreviateNanos(long duration, TimeUnit min) {
        return TimeUtils.abbreviate(duration, TimeUnit.NANOSECONDS, min, TimeUtils.max());
    }

    public static String abbreviate(long duration, TimeUnit sourceUnit, TimeUnit min) {
        return TimeUtils.abbreviate(duration, sourceUnit, min, TimeUtils.max());
    }

    public static String abbreviate(long duration, TimeUnit sourceUnit) {
        return TimeUtils.abbreviate(duration, sourceUnit, TimeUtils.min(), TimeUtils.max());
    }

    public static String abbreviate(long duration, TimeUnit sourceUnit, TimeUnit min, TimeUnit max) {
        String format = TimeUtils.format(duration, sourceUnit, min, max);
        return TimeUtils.abbreviate(format);
    }

    public static String format(long duration, TimeUnit sourceUnit, TimeUnit min, TimeUnit max) {
        StringBuilder res = new StringBuilder();
        String suffix = "";
        if (duration < 0L) {
            duration *= -1L;
            suffix = " ago";
        }
        TimeUnit current = max;
        while (duration > 0L) {
            long temp = current.convert(duration, sourceUnit);
            if (temp > 0L) {
                duration -= sourceUnit.convert(temp, current);
                res.append(temp).append(" ").append(current.name().toLowerCase());
                if (temp < 2L) {
                    res.deleteCharAt(res.length() - 1);
                }
                res.append(", ");
            }
            if (current == min) break;
            current = TimeUnit.values()[current.ordinal() - 1];
        }
        if (res.lastIndexOf(", ") < 0) {
            return "0 " + min.name().toLowerCase();
        }
        res.deleteCharAt(res.length() - 1);
        res.deleteCharAt(res.length() - 1);
        int i = res.lastIndexOf(", ");
        if (i > 0) {
            res.deleteCharAt(i);
            res.insert(i, " and");
        }
        res.append(suffix);
        return res.toString();
    }

    public static String formatHighest(long duration, TimeUnit max) {
        TimeUnit[] units = TimeUnit.values();
        StringBuilder res = new StringBuilder();
        TimeUnit current = max;
        while (duration > 0L) {
            long temp = current.convert(duration, TimeUnit.MILLISECONDS);
            if (temp > 0L) {
                duration -= current.toMillis(temp);
                res.append(temp).append(" ").append(current.name().toLowerCase());
                if (temp >= 2L) break;
                res.deleteCharAt(res.length() - 1);
                break;
            }
            if (current == TimeUnit.MILLISECONDS) break;
            current = units[current.ordinal() - 1];
        }
        return res.toString();
    }

    public static String abbreviate(String time) {
        time = time.replaceAll(" days", "d");
        time = time.replaceAll(" day", "d");
        time = time.replaceAll(" hours", "hr");
        time = time.replaceAll(" hour", "hr");
        time = time.replaceAll(" minutes", "m");
        time = time.replaceAll(" minute", "m");
        time = time.replaceAll(" seconds", "s");
        time = time.replaceAll(" second", "s");
        time = time.replaceAll(" milliseconds", "ms");
        time = time.replaceAll(" millisecond", "ms");
        return time;
    }

    public static String daysAndMinutes(long duration) {
        return TimeUtils.formatMillis(duration, TimeUnit.MINUTES, TimeUnit.DAYS);
    }

    public static String hoursAndMinutes(long duration) {
        return TimeUtils.formatMillis(duration, TimeUnit.MINUTES, TimeUnit.HOURS);
    }

    public static String hoursAndSeconds(long duration) {
        return TimeUtils.formatMillis(duration, TimeUnit.SECONDS, TimeUnit.HOURS);
    }
}

