/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Futures {
    private Futures() {
    }

    public static <V> Future<List<V>> of(Future<V> ... futures) {
        return new FutureList<V>(Arrays.asList(futures));
    }

    static class FutureList<V>
    implements Future<List<V>> {
        final List<Future<V>> futures = new ArrayList<Future<V>>();

        public FutureList(List<Future<V>> futures) {
            this.futures.addAll(futures);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean b = true;
            for (Future<V> future : this.futures) {
                if (future.cancel(mayInterruptIfRunning)) continue;
                b = false;
            }
            return b;
        }

        @Override
        public boolean isCancelled() {
            for (Future<V> future : this.futures) {
                if (future.isCancelled()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isDone() {
            for (Future<V> future : this.futures) {
                if (future.isDone()) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<V> get() throws InterruptedException, ExecutionException {
            ArrayList<V> list = new ArrayList<V>();
            for (Future<V> future : this.futures) {
                list.add(future.get());
            }
            return list;
        }

        @Override
        public List<V> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ArrayList<V> list = new ArrayList<V>();
            long max = System.nanoTime() + unit.toNanos(timeout);
            for (Future<V> future : this.futures) {
                long remaining = max - System.nanoTime();
                if (remaining < 0L) {
                    throw new TimeoutException();
                }
                V v = future.get(remaining, TimeUnit.NANOSECONDS);
                list.add(v);
            }
            return list;
        }
    }
}

