/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

public class Escapes {
    private Escapes() {
    }

    public static String unescape(String oldstr) {
        StringBuilder newString = new StringBuilder(oldstr.length());
        boolean sawBackslash = false;
        for (int i = 0; i < oldstr.length(); ++i) {
            int cp = oldstr.codePointAt(i);
            if (oldstr.codePointAt(i) > 65535) {
                ++i;
            }
            if (!sawBackslash) {
                if (cp == 92) {
                    sawBackslash = true;
                    continue;
                }
                newString.append(Character.toChars(cp));
                continue;
            }
            if (cp == 92) {
                sawBackslash = false;
                newString.append('\\');
                newString.append('\\');
                continue;
            }
            switch (cp) {
                case 114: {
                    newString.append('\r');
                    break;
                }
                case 110: {
                    newString.append('\n');
                    break;
                }
                case 102: {
                    newString.append('\f');
                    break;
                }
                case 98: {
                    newString.append("\\b");
                    break;
                }
                case 116: {
                    newString.append('\t');
                    break;
                }
                case 97: {
                    newString.append('\u0007');
                    break;
                }
                case 101: {
                    newString.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i == oldstr.length()) {
                        throw new IllegalArgumentException("trailing \\c");
                    }
                    cp = oldstr.codePointAt(i);
                    if (cp > 127) {
                        throw new IllegalArgumentException("expected ASCII after \\c");
                    }
                    newString.append(Character.toChars(cp ^ 0x40));
                    break;
                }
                case 56: 
                case 57: {
                    throw new IllegalArgumentException("illegal octal digit");
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    --i;
                }
                case 48: {
                    int value;
                    char ch;
                    int j;
                    if (i + 1 == oldstr.length()) {
                        newString.append(Character.toChars(0));
                        break;
                    }
                    ++i;
                    int digits = 0;
                    for (j = 0; j <= 2 && i + j != oldstr.length() && (ch = oldstr.charAt(i + j)) >= '0' && ch <= '7'; ++j) {
                        ++digits;
                    }
                    if (digits == 0) {
                        --i;
                        newString.append('\u0000');
                        break;
                    }
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + digits), 8);
                        newString.append(Character.toChars(value));
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("invalid octal value for \\0 escape");
                    }
                    i += digits - 1;
                    break;
                }
                case 120: {
                    char ch;
                    int j;
                    if (i + 2 > oldstr.length()) {
                        throw new IllegalArgumentException("string too short for \\x escape");
                    }
                    boolean sawBrace = false;
                    if (oldstr.charAt(++i) == '{') {
                        ++i;
                        sawBrace = true;
                    }
                    for (j = 0; j < 8 && (sawBrace || j != 2); ++j) {
                        ch = oldstr.charAt(i + j);
                        if (ch > '\u007f') {
                            throw new IllegalArgumentException("illegal non-ASCII hex digit in \\x escape");
                        }
                        if (sawBrace && ch == '}') break;
                        if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
                        throw new IllegalArgumentException(String.format("illegal hex digit #%d '%c' in \\x", ch, (int)ch));
                    }
                    if (j == 0) {
                        throw new IllegalArgumentException("empty braces in \\x{} escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("invalid hex value for \\x escape");
                    }
                    newString.append(Character.toChars(value));
                    if (sawBrace) {
                        ++j;
                    }
                    i += j - 1;
                    break;
                }
                case 117: {
                    int j;
                    if (i + 4 > oldstr.length()) {
                        throw new IllegalArgumentException("string too short for \\u escape");
                    }
                    ++i;
                    for (j = 0; j < 4; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                        throw new IllegalArgumentException("illegal non-ASCII hex digit in \\u escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("invalid hex value for \\u escape");
                    }
                    newString.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                case 85: {
                    int j;
                    if (i + 8 > oldstr.length()) {
                        throw new IllegalArgumentException("string too short for \\U escape");
                    }
                    ++i;
                    for (j = 0; j < 8; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                        throw new IllegalArgumentException("illegal non-ASCII hex digit in \\U escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("invalid hex value for \\U escape");
                    }
                    newString.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                default: {
                    newString.append('\\');
                    newString.append(Character.toChars(cp));
                }
            }
            sawBackslash = false;
        }
        if (sawBackslash) {
            newString.append('\\');
        }
        return newString.toString();
    }
}

