/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.nio.charset.Charset;
import org.tomitribe.util.Base32;
import org.tomitribe.util.Base58;
import org.tomitribe.util.Base64;
import org.tomitribe.util.Hex;

public class Longs {
    private Longs() {
    }

    public static byte[] toBytes(long v) {
        byte[] bytes = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return bytes;
    }

    public static long fromBytes(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes are null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes length not 8: " + bytes.length);
        }
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
    }

    public static String toHex(long value) {
        byte[] bytes = Longs.toBytes(value);
        return Hex.toString(bytes);
    }

    public static long fromHex(String hex) {
        byte[] bytes = Hex.fromString(hex);
        return Longs.fromBytes(bytes);
    }

    public static String toBase32(long value) {
        byte[] bytes = Longs.toBytes(value);
        return Base32.encode(bytes);
    }

    public static long fromBase32(String base32) {
        try {
            byte[] bytes = Base32.decode(base32);
            return Longs.fromBytes(bytes);
        }
        catch (Base32.DecodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String toBase64(long value) {
        byte[] bytes = Longs.toBytes(value);
        return new String(Base64.encodeBase64(bytes), Charset.forName("UTF-8"));
    }

    public static long fromBase64(String base64) {
        byte[] bytes = Base64.decodeBase64(base64.getBytes(Charset.forName("UTF-8")));
        return Longs.fromBytes(bytes);
    }

    public static String toBase58(long value) {
        byte[] bytes = Longs.toBytes(value);
        return Base58.encode(bytes);
    }

    public static long fromBase58(String base58) {
        byte[] bytes = Base58.decode(base58);
        return Longs.fromBytes(bytes);
    }
}

