/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.hash;

import org.tomitribe.util.hash.JvmUtils;
import org.tomitribe.util.hash.Preconditions;
import org.tomitribe.util.hash.Slice;
import org.tomitribe.util.hash.Slices;

public class XxHash32 {
    private static final int PRIME32_1 = 506952113;
    private static final int PRIME32_2 = 99338871;
    private static final int PRIME32_3 = 1119006269;
    private static final int PRIME32_4 = 668265263;
    private static final int PRIME32_5 = 374761393;
    private static final int DEFAULT_SEED = 0;

    private XxHash32() {
    }

    public static int hash(String data) {
        return XxHash32.hash(Slices.utf8Slice(data));
    }

    public static int hash(Slice data) {
        return XxHash32.hash(data, 0, data.length());
    }

    public static int hash(int seed, Slice data) {
        return XxHash32.hash(seed, data, 0, data.length());
    }

    public static int hash(Slice data, int offset, int length) {
        return XxHash32.hash(0, data, offset, length);
    }

    public static int hash(int seed, Slice data, int offset, int length) {
        int hash;
        Preconditions.checkPositionIndexes(0, offset + length, data.length());
        Object base = data.getBase();
        long p = data.getAddress() + (long)offset;
        long end = p + (long)length;
        if (length >= 16) {
            int v1 = seed + 506952113 + 99338871;
            int v2 = seed + 99338871;
            int v3 = seed + 0;
            int v4 = seed - 506952113;
            long limit = end - 16L;
            do {
                v1 = XxHash32.mix(v1, JvmUtils.unsafe.getInt(base, p));
                v2 = XxHash32.mix(v2, JvmUtils.unsafe.getInt(base, p += 4L));
                v3 = XxHash32.mix(v3, JvmUtils.unsafe.getInt(base, p += 4L));
                v4 = XxHash32.mix(v4, JvmUtils.unsafe.getInt(base, p += 4L));
            } while ((p += 4L) <= limit);
            hash = Integer.rotateLeft(v1, 1) + Integer.rotateLeft(v2, 7) + Integer.rotateLeft(v3, 12) + Integer.rotateLeft(v4, 18);
        } else {
            hash = seed + 374761393;
        }
        hash += length;
        if (p <= end - 4L) {
            hash += JvmUtils.unsafe.getInt(base, p) * 1119006269;
            hash = Integer.rotateLeft(hash, 17) * 668265263;
            p += 4L;
        }
        while (p < end) {
            int unsigned = JvmUtils.unsafe.getByte(base, p) & 0xFF;
            hash += unsigned * 374761393;
            hash = Integer.rotateLeft(hash, 11) * 506952113;
            ++p;
        }
        hash ^= hash >>> 15;
        hash *= 99338871;
        hash ^= hash >>> 13;
        hash *= 1119006269;
        hash ^= hash >>> 16;
        return hash;
    }

    private static int mix(int current, int value) {
        return Integer.rotateLeft(current + value * 99338871, 13) * 506952113;
    }
}

