/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.collect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tomitribe.util.editor.Converter;
import org.tomitribe.util.reflect.SetAccessible;

public class ObjectMap
extends AbstractMap<String, Object> {
    private final Object object;
    private Map<String, Map.Entry<String, Object>> attributes;
    private Set<Map.Entry<String, Object>> entries;

    public ObjectMap(Object object) {
        this(object.getClass(), object);
    }

    public ObjectMap(Class clazz) {
        this(clazz, null);
    }

    public ObjectMap(Class<?> clazz, Object object) {
        this.object = object;
        this.attributes = new HashMap<String, Map.Entry<String, Object>>();
        for (Field field : clazz.getFields()) {
            FieldEntry entry = new FieldEntry(field);
            this.attributes.put(entry.getKey(), entry);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (!this.isValidGetter((Method)accessibleObject)) continue;
            String name = ((Method)accessibleObject).getName().replaceFirst("(get|is|find)", "set");
            Method setter = this.getOptionalMethod(clazz, name, ((Method)accessibleObject).getReturnType());
            MethodEntry entry = new MethodEntry(name, (Method)accessibleObject, setter);
            this.attributes.put(entry.getKey(), entry);
        }
        this.entries = Collections.unmodifiableSet(new HashSet<Map.Entry<String, Object>>(this.attributes.values()));
    }

    private boolean isValidGetter(Method m) {
        if (Modifier.isAbstract(m.getModifiers())) {
            return false;
        }
        if (Void.TYPE.equals(m.getReturnType())) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        if (m.getName().startsWith("get") || m.getName().startsWith("find")) {
            return true;
        }
        if (!m.getName().startsWith("is")) {
            return false;
        }
        if (m.getReturnType().equals(Boolean.class)) {
            return true;
        }
        return m.getReturnType().equals(Boolean.TYPE);
    }

    private Method getOptionalMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException thisIsOk) {
            return null;
        }
    }

    @Override
    public Object get(Object key) {
        Map.Entry<String, Object> entry = this.attributes.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public Object put(String key, Object value) {
        Map.Entry<String, Object> entry = this.attributes.get(key);
        if (entry == null) {
            return null;
        }
        return entry.setValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entries;
    }

    public class MethodEntry
    implements Member {
        private final String key;
        private final Method getter;
        private final Method setter;

        public MethodEntry(String methodName, Method getter, Method setter) {
            StringBuilder name = new StringBuilder(methodName);
            name.delete(0, 3);
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            this.key = name.toString();
            this.getter = getter;
            this.setter = setter;
        }

        protected Object invoke(Method method, Object ... args) {
            SetAccessible.on(method);
            try {
                return method.invoke(ObjectMap.this.object, args);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Key: %s, Method: %s", this.key, method.toString()), e);
            }
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.invoke(this.getter, new Object[0]);
        }

        @Override
        public Object setValue(Object value) {
            if (this.setter == null) {
                throw new IllegalArgumentException(String.format("'%s' is read-only", this.key));
            }
            Object original = this.getValue();
            value = Converter.convert(value, this.setter.getParameterTypes()[0], this.getKey());
            this.invoke(this.setter, value);
            return original;
        }

        @Override
        public Class<?> getType() {
            return this.getter.getReturnType();
        }

        @Override
        public boolean isReadOnly() {
            return this.setter != null;
        }
    }

    public static interface Member
    extends Map.Entry<String, Object> {
        public Class<?> getType();

        public boolean isReadOnly();
    }

    public class FieldEntry
    implements Member {
        private final Field field;

        public FieldEntry(Field field) {
            this.field = field;
        }

        @Override
        public String getKey() {
            return this.field.getName();
        }

        @Override
        public Object getValue() {
            try {
                return this.field.get(ObjectMap.this.object);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Object setValue(Object value) {
            try {
                Object replaced = this.getValue();
                value = Converter.convert(value, this.field.getType(), this.getKey());
                this.field.set(ObjectMap.this.object, value);
                return replaced;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }
}

