/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import org.tomitribe.util.Hex;

public class Longs {
    private Longs() {
    }

    public static byte[] toBytes(long v) {
        byte[] bytes = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return bytes;
    }

    public static long fromBytes(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes are null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes length not 8: " + bytes.length);
        }
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
    }

    public static String toHex(long value) {
        byte[] bytes = Longs.toBytes(value);
        return Hex.toString(bytes);
    }

    public static long fromHex(String hex) {
        byte[] bytes = Hex.fromString(hex);
        return Longs.fromBytes(bytes);
    }
}

