/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.reflect;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Classes {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPERS = new HashMap();
    private static final HashMap<String, Class> PRIMITIVES = new HashMap();

    private Classes() {
    }

    public static Class forName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        int arrayDimentions = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++arrayDimentions;
        }
        Class<?> clazz = PRIMITIVES.get(string);
        if (clazz == null) {
            clazz = Class.forName(string, true, classLoader);
        }
        if (arrayDimentions == 0) {
            return clazz;
        }
        return Array.newInstance(clazz, new int[arrayDimentions]).getClass();
    }

    public static String packageName(Class clazz) {
        return Classes.packageName(clazz.getName());
    }

    public static String packageName(String clazzName) {
        int i = clazzName.lastIndexOf(46);
        if (i > 0) {
            return clazzName.substring(0, i);
        }
        return "";
    }

    public static List<String> getSimpleNames(Class ... classes) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class aClass : classes) {
            list.add(aClass.getSimpleName());
        }
        return list;
    }

    public static Class<?> deprimitivize(Class<?> fieldType) {
        return fieldType.isPrimitive() ? PRIMITIVE_WRAPPERS.get(fieldType) : fieldType;
    }

    public static List<Class<?>> ancestors(Class clazz) {
        ArrayList ancestors = new ArrayList();
        while (clazz != null && !clazz.equals(Object.class)) {
            ancestors.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return ancestors;
    }

    static {
        PRIMITIVES.put("boolean", Boolean.TYPE);
        PRIMITIVES.put("byte", Byte.TYPE);
        PRIMITIVES.put("char", Character.TYPE);
        PRIMITIVES.put("short", Short.TYPE);
        PRIMITIVES.put("int", Integer.TYPE);
        PRIMITIVES.put("long", Long.TYPE);
        PRIMITIVES.put("float", Float.TYPE);
        PRIMITIVES.put("double", Double.TYPE);
        PRIMITIVE_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPERS.put(Short.TYPE, Short.class);
    }
}

