/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterable<T>
implements Iterator<T> {
    private final Iterator<Iterable<T>> archives;
    private Iterator<T> current;

    private CompositeIterable(Iterable<Iterable<T>> archives) {
        this.archives = archives.iterator();
        if (this.archives.hasNext()) {
            this.current = this.archives.next().iterator();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            return false;
        }
        if (this.current.hasNext()) {
            return true;
        }
        if (this.archives.hasNext()) {
            this.current = this.archives.next().iterator();
            return this.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

