/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.tomitribe.util.Join;
import org.tomitribe.util.editor.Editors;

public class Duration {
    private long time;
    private TimeUnit unit;

    public Duration() {
    }

    public Duration(long time, TimeUnit unit) {
        this.time = time;
        this.unit = unit;
    }

    public Duration(String string) {
        this(string, null);
    }

    public Duration(String string, TimeUnit defaultUnit) {
        String[] strings = string.split(",| and ");
        Duration total = new Duration();
        for (String value : strings) {
            char c;
            int i;
            Duration part = new Duration();
            String s = value.trim();
            StringBuilder t = new StringBuilder();
            StringBuilder u = new StringBuilder();
            for (i = 0; i < s.length() && (Character.isDigit(c = s.charAt(i)) || i == 0 && c == '-'); ++i) {
                t.append(c);
            }
            if (t.length() == 0) {
                Duration.invalidFormat(s);
            }
            while (i < s.length() && Character.isWhitespace(c = s.charAt(i))) {
                ++i;
            }
            while (i < s.length()) {
                c = s.charAt(i);
                if (Character.isLetter(c)) {
                    u.append(c);
                } else {
                    Duration.invalidFormat(s);
                }
                ++i;
            }
            part.time = Integer.parseInt(t.toString());
            part.unit = Duration.parseUnit(u.toString());
            if (part.unit == null) {
                part.unit = defaultUnit;
            }
            total = total.add(part);
        }
        this.time = total.time;
        this.unit = total.unit;
    }

    public long getTime() {
        return this.time;
    }

    public long getTime(TimeUnit unit) {
        return unit.convert(this.time, this.unit);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration that = (Duration)o;
        Normalize n = new Normalize(this, that);
        return n.a == n.b;
    }

    public int hashCode() {
        int result = (int)(this.time ^ this.time >>> 32);
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public Duration add(Duration that) {
        Normalize n = new Normalize(this, that);
        return new Duration(n.a + n.b, n.base);
    }

    public Duration subtract(Duration that) {
        Normalize n = new Normalize(this, that);
        return new Duration(n.a - n.b, n.base);
    }

    public static Duration parse(String text) {
        return new Duration(text);
    }

    private static void invalidFormat(String text) {
        throw new IllegalArgumentException("Illegal duration format: '" + text + "'.  Valid examples are '10s' or '10 seconds'.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.time);
        if (this.unit != null) {
            sb.append(" ");
            sb.append((Object)this.unit);
        }
        return sb.toString();
    }

    private static TimeUnit parseUnit(String u) {
        if (u.length() == 0) {
            return null;
        }
        if ("NANOSECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANOSECOND".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANOS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANO".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("MICROSECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICROSECOND".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICROS".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICRO".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MILLISECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLISECOND".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLIS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLI".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("SECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("SECOND".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("SEC".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("S".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("MINUTES".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("MINUTE".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("MIN".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("M".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("HOURS".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HOUR".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HRS".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HR".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("H".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("DAYS".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        if ("DAY".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        if ("D".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("Unknown time unit '" + u + "'.  Supported units " + Join.join(", ", Duration.lowercase(TimeUnit.values())));
    }

    private static List<String> lowercase(Enum ... units) {
        ArrayList<String> list = new ArrayList<String>();
        for (Enum unit : units) {
            list.add(unit.name().toLowerCase());
        }
        return list;
    }

    static {
        PropertyEditorManager.registerEditor(Duration.class, DurationEditor.class);
        Editors.get(Duration.class);
    }

    public static class DurationEditor
    extends PropertyEditorSupport {
        @Override
        public void setAsText(String text) {
            Duration d = Duration.parse(text);
            this.setValue(d);
        }
    }

    private static class Normalize {
        private long a;
        private long b;
        private TimeUnit base;

        private Normalize(Duration a, Duration b) {
            this.base = Normalize.lowest(a, b);
            this.a = a.unit == null ? a.time : this.base.convert(a.time, a.unit);
            this.b = b.unit == null ? b.time : this.base.convert(b.time, b.unit);
        }

        private static TimeUnit lowest(Duration a, Duration b) {
            if (a.unit == null) {
                return b.unit;
            }
            if (b.unit == null) {
                return a.unit;
            }
            if (a.time == 0L) {
                return b.unit;
            }
            if (b.time == 0L) {
                return a.unit;
            }
            return TimeUnit.values()[Math.min(a.unit.ordinal(), b.unit.ordinal())];
        }
    }
}

