/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.tomitribe.crest.table.Data;
import org.tomitribe.crest.table.Line;
import org.tomitribe.crest.table.Width;
import org.tomitribe.util.Join;

public class Border {
    private final Line first;
    private final Line last;
    private final Line header;
    private final Line inner;
    private final Line row;
    private final Function<String, String> escape;

    public Border(Line first, Line last, Line header, Line inner, Line row, Function<String, String> escape) {
        this.first = first;
        this.last = last;
        this.header = header;
        this.inner = inner;
        this.row = row;
        this.escape = escape;
    }

    public String escape(String value) {
        return this.escape.apply(value);
    }

    public String getRowFormat(List<Data.Column> columns) {
        List formats = columns.stream().map(column -> {
            int width = column.getWidth().getMax();
            return column.isNumeric() ? "%" + width + "s" : "%-" + width + "s";
        }).collect(Collectors.toList());
        Line row = this.getRow();
        return row.getLeft() + Join.join((String)row.getInner(), formats) + row.getRight();
    }

    public Line getFirst() {
        return this.first;
    }

    public Line getLast() {
        return this.last;
    }

    public Line getHeader() {
        return this.header;
    }

    public Line getInner() {
        return this.inner;
    }

    public Line getRow() {
        return this.row;
    }

    public Width getWidth(int columns) {
        int width = this.row.getLeft().length() + this.row.getRight().length() + this.row.getInner().length() * Math.max(0, columns - 1);
        return new Width(width, width);
    }

    public static Builder whitespaceSeparated() {
        return Border.builder().first(null).header("", " ", "   ", "").row("", "   ", "").inner("", " ", "   ", "").last(null);
    }

    public static Builder whitespaceCompact() {
        return Border.builder().first(null).inner(null).last(null).header("", " ", "   ", "").row("", "   ", "");
    }

    public static Builder mysqlStyle() {
        return Border.builder().first("+-", "-", "-+-", "-+").header("+-", "-", "-+-", "-+").row("| ", " | ", " |").last("+-", "-", "-+-", "-+").inner(null);
    }

    public static Builder asciiSeparated() {
        return Border.builder().first("+=", "=", "=+=", "=+").header("+=", "=", "=+=", "=+").row("| ", " | ", " |").inner("+-", "-", "-+-", "-+").last("+-", "-", "-+-", "-+");
    }

    public static Builder asciiCompact() {
        return Border.builder().first(null).inner(null).last(null).header("-", "-", "- -", "-").row(" ", "   ", " ");
    }

    public static Builder githubMarkdown() {
        return Border.builder().first(null).inner(null).last(null).header("|-", "-", "-|-", "-|").row("| ", " | ", " |");
    }

    public static Builder redditMarkdown() {
        return Border.builder().first(null).inner(null).last(null).header("-", "-", "-|-", "-").row(" ", " | ", " ");
    }

    public static Builder reStructuredTextGrid() {
        return Border.builder().first("+-", "-", "-+-", "-+").header("+=", "=", "=+=", "=+").row("| ", " | ", " |").last("+-", "-", "-+-", "-+").inner(null);
    }

    public static Builder reStructuredTextSimple() {
        return Border.builder().first("=", "=", "= =", "=").header("=", "=", "= =", "=").row(" ", "   ", " ").last("=", "=", "= =", "=").inner(null);
    }

    public static Builder asciiDots() {
        return Border.builder().first("..", ".", "...", "..").header(":.", ".", ".:.", ".:").row(": ", " : ", " :").last(":.", ".", ".:.", ".:").inner(null);
    }

    public static Builder unicodeDouble() {
        return Border.builder().first("\u2554\u2550", "\u2550", "\u2550\u2566\u2550", "\u2550\u2557").header("\u2560\u2550", "\u2550", "\u2550\u256c\u2550", "\u2550\u2563").row("\u2551 ", " \u2551 ", " \u2551").last("\u255a\u2550", "\u2550", "\u2550\u2569\u2550", "\u2550\u255d").inner(null);
    }

    public static Builder unicodeSingle() {
        return Border.builder().first("\u250c\u2500", "\u2500", "\u2500\u252c\u2500", "\u2500\u2510").header("\u251c\u2500", "\u2500", "\u2500\u253c\u2500", "\u2500\u2524").row("\u2502 ", " \u2502 ", " \u2502").last("\u2514\u2500", "\u2500", "\u2500\u2534\u2500", "\u2500\u2518").inner(null);
    }

    public static Builder unicodeSingleSeparated() {
        return Border.builder().first("\u250c\u2500", "\u2500", "\u2500\u252c\u2500", "\u2500\u2510").header("\u251c\u2550", "\u2550", "\u2550\u253c\u2550", "\u2550\u2524").inner("\u251c\u2500", "\u2500", "\u2500\u253c\u2500", "\u2500\u2524").row("\u2502 ", " \u2502 ", " \u2502").last("\u2514\u2500", "\u2500", "\u2500\u2534\u2500", "\u2500\u2518");
    }

    public static Builder tsv() {
        return Border.builder().first(null).header(null).inner(null).row(Line.builder().left("").inner("\t").right("").padded(false)).last(null).escape((String s) -> s.replace("\t", "    "));
    }

    public static Builder csv() {
        return Border.builder().first(null).header(null).inner(null).row(Line.builder().left("").inner(",").right("").padded(false)).last(null).escape((String string) -> {
            if (string.contains(",") || string.contains("\"") || string.contains("\n")) {
                String escapedInput = string.replace("\"", "\"\"");
                return "\"" + escapedInput + "\"";
            }
            return string;
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Line.Builder first = Line.builder();
        private Line.Builder last = Line.builder();
        private Line.Builder header = Line.builder();
        private Line.Builder inner = Line.builder();
        private Line.Builder middle = Line.builder();
        private Function<String, String> escape = Function.identity();

        private Builder() {
        }

        public List<Line.Builder> all() {
            return Arrays.asList(this.first, this.last, this.header, this.inner, this.middle);
        }

        public Line.Builder first() {
            return this.first.all("").inner("   ");
        }

        public Line.Builder last() {
            return this.last;
        }

        public Line.Builder header() {
            return this.header;
        }

        public Line.Builder inner() {
            return this.inner;
        }

        public Line.Builder row() {
            return this.middle;
        }

        public Builder first(Line.Builder first) {
            this.first = first;
            return this;
        }

        public Builder last(Line.Builder last) {
            this.last = last;
            return this;
        }

        public Builder header(Line.Builder header) {
            this.header = header;
            return this;
        }

        public Builder inner(Line.Builder inner) {
            this.inner = inner;
            return this;
        }

        public Builder row(Line.Builder middle) {
            this.middle = middle;
            return this;
        }

        public Builder first(String left, String middle, String inner, String right) {
            this.first.left(left).middle(middle).inner(inner).right(right);
            return this;
        }

        public Builder header(String left, String middle, String inner, String right) {
            this.header.left(left).middle(middle).inner(inner).right(right);
            return this;
        }

        public Builder row(String left, String inner, String right) {
            this.middle.left(left).inner(inner).right(right);
            return this;
        }

        public Builder inner(String left, String middle, String inner, String right) {
            this.inner.left(left).middle(middle).inner(inner).right(right);
            return this;
        }

        public Builder last(String left, String middle, String inner, String right) {
            this.last.left(left).middle(middle).inner(inner).right(right);
            return this;
        }

        public Builder escape(Function<String, String> escape) {
            this.escape = escape;
            return this;
        }

        public Border build() {
            return new Border(this.first != null ? this.first.build() : null, this.last != null ? this.last.build() : null, this.header != null ? this.header.build() : null, this.inner != null ? this.inner.build() : null, this.middle != null ? this.middle.build() : null, this.escape);
        }
    }
}

