/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.javadoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.tomitribe.crest.javadoc.Javadoc;
import org.tomitribe.util.Join;

public class JavadocParser {
    private final Javadoc.Builder javadoc = Javadoc.builder();
    private final String content;

    public JavadocParser(String content) {
        this.content = content;
    }

    private Javadoc parse() {
        ArrayList<String> parts = this.splitParts();
        if (parts.size() == 0) {
            return this.javadoc.build();
        }
        if (!parts.get(0).startsWith("@")) {
            this.javadoc.content(parts.remove(0));
        }
        List tags = parts.stream().filter(s -> s.startsWith("@")).map(JavadocParser::toTag).filter(Objects::nonNull).collect(Collectors.toList());
        for (Javadoc.Tag tag : tags) {
            this.convert(tag);
        }
        return this.javadoc.build();
    }

    private void convert(Javadoc.Tag tag) {
        if ("param".equals(tag.getName())) {
            this.param(tag);
        } else if ("throws".equals(tag.getName())) {
            this.throwing(tag);
        } else if ("author".equals(tag.getName())) {
            this.author(tag);
        } else if ("see".equals(tag.getName())) {
            this.see(tag);
        } else if ("return".equals(tag.getName())) {
            this.returning(tag);
        } else if ("since".equals(tag.getName())) {
            this.since(tag);
        } else if ("version".equals(tag.getName())) {
            this.version(tag);
        } else if ("deprecated".equals(tag.getName())) {
            this.deprecated(tag);
        } else {
            this.javadoc.unknown(tag);
        }
    }

    private void deprecated(Javadoc.Tag tag) {
        this.javadoc.deprecated(new Javadoc.Deprecated(tag.getContent()));
    }

    private void version(Javadoc.Tag tag) {
        this.javadoc.version(new Javadoc.Version(tag.getContent()));
    }

    private void since(Javadoc.Tag tag) {
        this.javadoc.since(new Javadoc.Since(tag.getContent()));
    }

    private void returning(Javadoc.Tag tag) {
        this.javadoc.aReturn(new Javadoc.Return(tag.getContent()));
    }

    private void see(Javadoc.Tag tag) {
        this.javadoc.see(new Javadoc.See(tag.getContent()));
    }

    private void author(Javadoc.Tag tag) {
        this.javadoc.author(new Javadoc.Author(tag.getContent()));
    }

    private void throwing(Javadoc.Tag tag) {
        Map.Entry<String, String> entry = JavadocParser.parseKeyValue(tag.getContent());
        if (entry != null) {
            this.javadoc.throwing(new Javadoc.Throws(entry.getKey(), entry.getValue()));
        }
    }

    private void param(Javadoc.Tag tag) {
        Map.Entry<String, String> entry = JavadocParser.parseKeyValue(tag.getContent());
        if (entry != null) {
            this.javadoc.param(new Javadoc.Param(entry.getKey(), entry.getValue()));
        }
    }

    static Javadoc.Tag toTag(String text) {
        text = text.substring(1).trim();
        Map.Entry<String, String> pair = JavadocParser.parseKeyValue(text);
        return new Javadoc.Tag(pair.getKey(), pair.getValue());
    }

    private static Map.Entry<String, String> parseKeyValue(String text) {
        String delimiter = "\u0000\u0000\u0000";
        String[] parts = text.replaceFirst("[\n\t ]", "\u0000\u0000\u0000").split("\u0000\u0000\u0000");
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return new Pair(parts[0], null);
        }
        if (parts.length == 2) {
            String name = parts[0].trim();
            String content = parts[1].trim();
            return new Pair(name, content);
        }
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(parts));
        String name = strings.remove(0).trim();
        String content = Join.join((String)"\u0000\u0000\u0000", strings).trim();
        return new Pair(name, content);
    }

    private ArrayList<String> splitParts() {
        if (this.content == null) {
            return new ArrayList<String>();
        }
        String[] parts = this.content.replaceFirst("^ *@", "@").replaceAll("\n *@", "\n\u0000@").split("\n\u0000");
        return new ArrayList<String>(Arrays.asList(parts));
    }

    public Javadoc build() {
        return this.javadoc.build();
    }

    public static Javadoc parse(String content) {
        return new JavadocParser(content).parse();
    }

    public static class Pair
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }
}

