/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.interceptor.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.tomitribe.crest.api.interceptor.CrestContext;
import org.tomitribe.crest.api.interceptor.ParameterMetadata;
import org.tomitribe.crest.interceptor.UnresolvedInterceptorAnnotationException;
import org.tomitribe.crest.interceptor.internal.InternalInterceptor;

public abstract class InternalInterceptorInvocationContext {
    private final Map<Class<?>, InternalInterceptor> interceptors;
    private final CrestContext context;
    private final Class<?>[] interceptorKeys;
    private List<Object> parameters;
    private int index = 0;

    public InternalInterceptorInvocationContext(Map<Class<?>, InternalInterceptor> interceptors, Class<?>[] interceptorKeys, final String name, final List<ParameterMetadata> parameterMetadatas, final Method method, final List<Object> parameters) {
        this.interceptorKeys = interceptorKeys;
        this.interceptors = interceptors;
        this.parameters = parameters;
        this.context = new CrestContext(){

            public Object proceed() {
                return InternalInterceptorInvocationContext.this.proceed();
            }

            public Method getMethod() {
                return method;
            }

            public List<Object> getParameters() {
                return parameters;
            }

            public String getName() {
                return name;
            }

            public List<ParameterMetadata> getParameterMetadata() {
                return parameterMetadatas;
            }
        };
    }

    public Object proceed() {
        if (this.index < this.interceptorKeys.length) {
            Class<?> interceptorClass = this.interceptorKeys[this.index];
            InternalInterceptor internalInterceptor = this.interceptors.get(interceptorClass);
            if (internalInterceptor == null) {
                if (interceptorClass.isAnnotation()) {
                    throw new UnresolvedInterceptorAnnotationException(interceptorClass);
                }
                internalInterceptor = InternalInterceptor.from(interceptorClass);
            }
            ++this.index;
            return internalInterceptor.intercept(this.context);
        }
        return this.doInvoke(this.parameters);
    }

    protected abstract Object doInvoke(List<Object> var1);
}

