/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.interceptor.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tomitribe.crest.api.interceptor.CrestContext;
import org.tomitribe.crest.api.interceptor.CrestInterceptor;
import org.tomitribe.crest.cmds.targets.SimpleBean;
import org.tomitribe.crest.cmds.targets.Target;
import org.tomitribe.crest.interceptor.InterceptorAnnotationNotFoundException;

public class InternalInterceptor {
    private final Target target;
    private final Method method;

    public InternalInterceptor(Target target, Method method) {
        this.target = target;
        this.method = method;
    }

    public Object intercept(CrestContext crestContext) {
        try {
            return this.target.invoke(this.method, crestContext);
        }
        catch (InvocationTargetException e) {
            return InternalInterceptor.throwRuntime(e.getCause());
        }
        catch (IllegalAccessException e) {
            return InternalInterceptor.throwRuntime(e);
        }
    }

    private static Object throwRuntime(Throwable cause) {
        throw RuntimeException.class.isInstance(cause) ? (RuntimeException)RuntimeException.class.cast(cause) : new IllegalStateException(cause);
    }

    public static InternalInterceptor from(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            CrestInterceptor interceptor;
            if (Object.class == method.getDeclaringClass() || (interceptor = method.getAnnotation(CrestInterceptor.class)) == null) continue;
            return new InternalInterceptor(new SimpleBean(null), method);
        }
        throw new InterceptorAnnotationNotFoundException(clazz);
    }
}

