/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.Attributes;

public class Manifest {
    private final java.util.jar.Manifest manifest;

    private Manifest(java.util.jar.Manifest manifest) {
        this.manifest = manifest;
    }

    public String getManifestVersion() {
        return this.get(Entry.MANIFEST_VERSION);
    }

    public String getCreatedBy() {
        return this.get(Entry.CREATED_BY);
    }

    public String getBuildJdkSpec() {
        return this.get(Entry.BUILD_JDK_SPEC);
    }

    public String getSpecificationTitle() {
        return this.get(Entry.SPECIFICATION_TITLE);
    }

    public String getSpecificationVersion() {
        return this.get(Entry.SPECIFICATION_VERSION);
    }

    public String getSpecificationVendor() {
        return this.get(Entry.SPECIFICATION_VENDOR);
    }

    public String getImplementationTitle() {
        return this.get(Entry.IMPLEMENTATION_TITLE);
    }

    public String getImplementationVersion() {
        return this.get(Entry.IMPLEMENTATION_VERSION);
    }

    public String getImplementationVendor() {
        return this.get(Entry.IMPLEMENTATION_VENDOR);
    }

    public String getMainClass() {
        return this.get(Entry.MAIN_CLASS);
    }

    public String getCommandName() {
        return this.get(Entry.COMMAND_NAME);
    }

    public String getCommandVersion() {
        return this.get(Entry.COMMAND_VERSION);
    }

    public String get(Entry entry) {
        return this.manifest.getMainAttributes().getValue(entry.toName());
    }

    public static List<Manifest> read() {
        return Manifest.read(Thread.currentThread().getContextClassLoader());
    }

    public static List<Manifest> read(ClassLoader classLoader) {
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Manifest manifest = Manifest.read(url);
                manifests.add(manifest);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read MANIFEST.MF entries from classpath", e);
        }
        return manifests;
    }

    public static Manifest read(URL url) {
        try {
            InputStream is = url.openStream();
            java.util.jar.Manifest javaManifest = new java.util.jar.Manifest(is);
            return new Manifest(javaManifest);
        }
        catch (IOException e) {
            throw new ManifestUrlReadException(url, (Throwable)e);
        }
    }

    public String write() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.manifest.write(baos);
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            throw new ManifestWriteException(e);
        }
    }

    public String toString() {
        String mainClass = this.getMainClass();
        String implementationVendor = this.getImplementationVendor();
        String implementationVersion = this.getImplementationVersion();
        String commandName = this.getCommandName();
        String commandVersion = this.getCommandVersion();
        return "Manifest{mainClass='" + mainClass + '\'' + ", implementationVendor='" + implementationVendor + '\'' + ", implementationVersion='" + implementationVersion + '\'' + ", commandName='" + commandName + '\'' + ", commandVersion='" + commandVersion + '\'' + '}';
    }

    public static Optional<Manifest> get() {
        String mainClassName = Manifest.findMainClassName();
        if (mainClassName == null) {
            return Optional.empty();
        }
        return Manifest.read().stream().filter(manifest -> manifest.getMainClass() != null).filter(manifest -> manifest.getMainClass().equals(mainClassName)).findFirst();
    }

    public static String findMainClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement ste = stackTrace[i];
            if (!"main".equals(ste.getMethodName())) continue;
            return ste.getClassName();
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ManifestWriteException
    extends RuntimeException {
        public ManifestWriteException(Throwable e) {
            super("Unable to format manifest instance as string", e);
        }
    }

    public static class ManifestUrlReadException
    extends RuntimeException {
        public ManifestUrlReadException(URL url, Throwable e) {
            super("Unable to read MANIFEST.MF file " + url, e);
        }
    }

    public static enum Entry {
        MANIFEST_VERSION("Manifest-Version"),
        COMMAND_NAME("Command-Name"),
        COMMAND_VERSION("Command-Version"),
        CREATED_BY("Created-By"),
        BUILD_JDK_SPEC("Build-Jdk-Spec"),
        SPECIFICATION_TITLE("Specification-Title"),
        SPECIFICATION_VERSION("Specification-Version"),
        SPECIFICATION_VENDOR("Specification-Vendor"),
        IMPLEMENTATION_TITLE("Implementation-Title"),
        IMPLEMENTATION_VERSION("Implementation-Version"),
        IMPLEMENTATION_VENDOR("Implementation-Vendor"),
        MAIN_CLASS("Main-Class");

        private final String value;

        private Entry(String value) {
            this.value = value;
        }

        public String get() {
            return this.value;
        }

        public Attributes.Name toName() {
            return new Attributes.Name(this.value);
        }
    }

    public static class Builder {
        private final java.util.jar.Manifest javaManifest = new java.util.jar.Manifest(new java.util.jar.Manifest());

        public Builder() {
            this.manifestVersion("1.0");
        }

        public Builder manifestVersion(String manifestVersion) {
            this.put(Entry.MANIFEST_VERSION, manifestVersion);
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.put(Entry.CREATED_BY, createdBy);
            return this;
        }

        public Builder buildJdkSpec(String buildJdkSpec) {
            this.put(Entry.BUILD_JDK_SPEC, buildJdkSpec);
            return this;
        }

        public Builder specificationTitle(String specificationTitle) {
            this.put(Entry.SPECIFICATION_TITLE, specificationTitle);
            return this;
        }

        public Builder specificationVersion(String specificationVersion) {
            this.put(Entry.SPECIFICATION_VERSION, specificationVersion);
            return this;
        }

        public Builder specificationVendor(String specificationVendor) {
            this.put(Entry.SPECIFICATION_VENDOR, specificationVendor);
            return this;
        }

        public Builder implementationTitle(String implementationTitle) {
            this.put(Entry.IMPLEMENTATION_TITLE, implementationTitle);
            return this;
        }

        public Builder implementationVersion(String implementationVersion) {
            this.put(Entry.IMPLEMENTATION_VERSION, implementationVersion);
            return this;
        }

        public Builder implementationVendor(String implementationVendor) {
            this.put(Entry.IMPLEMENTATION_VENDOR, implementationVendor);
            return this;
        }

        public Builder mainClass(Class<?> mainClass) {
            this.put(Entry.MAIN_CLASS, mainClass.getName());
            return this;
        }

        public Builder mainClass(String mainClass) {
            this.put(Entry.MAIN_CLASS, mainClass);
            return this;
        }

        public Builder commandName(String commandName) {
            this.put(Entry.COMMAND_NAME, commandName);
            return this;
        }

        public Builder commandVersion(String commandVersion) {
            this.put(Entry.COMMAND_VERSION, commandVersion);
            return this;
        }

        private Object put(Entry name, String value) {
            return this.javaManifest.getMainAttributes().put(name.toName(), value);
        }

        public Manifest build() {
            return new Manifest(this.javaManifest);
        }
    }
}

