/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.crest.table.Data;

public class Resize {
    private Resize() {
    }

    public static Data resize(Data data, int width) {
        if (data.getWidth().getMax() < width) {
            return data;
        }
        AtomicInteger remaining = new AtomicInteger(width - data.getWidth().getMin());
        List<Column> columns = data.getColumns().stream().map(column -> new Column((Data.Column)column, remaining)).collect(Collectors.toList());
        while (Resize.expand(columns)) {
        }
        Data.Cell[][] resized = new Data.Cell[data.getRows().size()][data.getColumns().size()];
        columns.stream().flatMap(Column::resize).forEach(cell -> {
            resized[cell.getRow()][cell.getColumn()] = cell;
        });
        return new Data(resized, data);
    }

    private static boolean expand(List<Column> columns) {
        return columns.stream().map(Column::expand).reduce((columnAExpanded, columnBExpanded) -> columnAExpanded != false || columnBExpanded != false).orElse(false);
    }

    public static class Column {
        private final Data.Column column;
        private final AtomicInteger remaining;
        private int size;

        public Column(Data.Column column, AtomicInteger remaining) {
            this.column = column;
            this.size = column.getWidth().getMin();
            this.remaining = remaining;
        }

        public boolean expand() {
            if (this.size == this.column.getWidth().getMax()) {
                return false;
            }
            if (this.remaining.getAndDecrement() <= 0) {
                return false;
            }
            ++this.size;
            return true;
        }

        public Stream<Data.Cell> resize() {
            return this.column.stream().map(cell -> cell.resizeTo(this.size));
        }
    }
}

