/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.help;

import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.crest.help.Option;
import org.tomitribe.util.Join;

public class Highlight {
    private final Pattern flags;
    private final Pattern code;

    public Highlight(List<Option> options) {
        List<String> flags = Highlight.flags(options);
        String format = String.format("([^A-Za-z0-9`-]|^)(%s)([^A-Za-z0-9-]|$)", Join.join((String)"|", flags));
        this.flags = Pattern.compile(format);
        this.code = Pattern.compile("`()([^`]+)`()");
    }

    static List<String> flags(List<Option> options) {
        return options.stream().map(Option::getFlag).map(s -> s.split(", ")).flatMap(Stream::of).map(s -> s.replaceAll("=.*", "")).map(String::trim).filter(s -> s.startsWith("-")).sorted(Comparator.reverseOrder()).sorted((o1, o2) -> Integer.compare(o2.length(), o1.length())).collect(Collectors.toList());
    }

    public String highlight(String text) {
        return String.format("\u001b[0m\u001b[1m%s\u001b[0m", text);
    }

    public String matches(String text) {
        text = this.matches(text, this.flags);
        text = this.matches(text, this.code);
        return text;
    }

    private String matches(String text, Pattern code) {
        return code.matcher(text).replaceAll("$1\u001b[0m\u001b[1m$2\u001b[0m$3");
    }
}

