/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tomitribe.crest.help.Document;
import org.tomitribe.crest.help.Element;
import org.tomitribe.crest.help.Heading;
import org.tomitribe.crest.help.HtmlDocumentParser;
import org.tomitribe.crest.help.Option;
import org.tomitribe.crest.help.Paragraph;
import org.tomitribe.util.Join;

public class DocumentParser {
    private final String content;
    private final Pattern leadingSpaces = Pattern.compile("^( *)");
    private final Pattern bullet = Pattern.compile("^( *-) *(.+)");
    private final Pattern heading = Pattern.compile("^[=#]+ *(.+)|^([A-Z]+[^a-z]+)$");
    private final Pattern preformatted = Pattern.compile("^    (.+)");
    private final Document.Builder doc = Document.builder();
    private State state;

    public DocumentParser(String content) {
        this.content = content;
    }

    public static Document parser(String content) {
        if (content == null || content.length() == 0) {
            return Document.builder().build();
        }
        if (HtmlDocumentParser.isHtml(content)) {
            return HtmlDocumentParser.parse(content);
        }
        return new DocumentParser(content).parse();
    }

    public static Document parseOptionDescription(String description) {
        Document.Builder document = Document.builder();
        Document parser = DocumentParser.parser(description);
        parser.getElements().stream().filter(element -> !(element instanceof Option)).map(DocumentParser::convertHeaders).forEach(document::element);
        return document.build();
    }

    private static Element convertHeaders(Element element) {
        if (element instanceof Heading) {
            return new Paragraph(element.getContent());
        }
        return element;
    }

    private Document parse() {
        List<String> lines = this.normalizeAndSplitContent();
        for (String line : lines) {
            if (this.processTerminator(line) || this.processHeader(line) || this.processBullet(line) || this.processPreformatted(line)) continue;
            this.processParagraph(line);
        }
        this.terminate();
        return this.doc.build();
    }

    private List<String> normalizeAndSplitContent() {
        List<String> lines = new ArrayList<String>(Arrays.asList(this.content.trim().replace("\t", "    ").replaceAll("\n *\n", "\n\n").split("\n")));
        lines = this.stripIndent(lines);
        return lines;
    }

    private boolean processPreformatted(String line) {
        Matcher matcher = this.preformatted.matcher(line);
        if (!matcher.find()) {
            return false;
        }
        if (this.state != null && !(this.state instanceof ReadingPreformatted)) {
            this.state.terminate();
            this.state = null;
        }
        if (this.state == null) {
            this.state = new ReadingPreformatted();
        }
        this.state.process(matcher.group(1));
        return true;
    }

    private boolean processTerminator(String line) {
        if (line.length() != 0) {
            return false;
        }
        this.terminate();
        return true;
    }

    private void processParagraph(String line) {
        if (this.state != null && !(this.state instanceof ReadingParagraph)) {
            this.state.terminate();
            this.state = null;
        }
        if (this.state == null) {
            this.state = new ReadingParagraph();
        }
        this.state.process(line);
    }

    private boolean processHeader(String line) {
        Matcher matcher = this.heading.matcher(line);
        if (!matcher.find()) {
            return false;
        }
        if (matcher.group(1) != null) {
            this.terminate();
            String text = matcher.group(1);
            this.doc.heading(text);
            return true;
        }
        if (matcher.group(2) != null) {
            this.terminate();
            String text = matcher.group(2);
            this.doc.heading(text);
            return true;
        }
        return false;
    }

    private boolean processBullet(String line) {
        Matcher matcher = this.bullet.matcher(line);
        if (matcher.find()) {
            this.terminate();
            String prefix = matcher.group(1);
            String text = matcher.group(2);
            this.state = new ReadingBullet(prefix);
            this.state.process(text);
            return true;
        }
        if (this.state instanceof ReadingBullet) {
            ReadingBullet readingBullet = (ReadingBullet)this.state;
            Matcher matcher2 = readingBullet.continued.matcher(line);
            if (!matcher2.find()) {
                return false;
            }
            String text = matcher2.group(1);
            readingBullet.process(text);
            return true;
        }
        return false;
    }

    private void terminate() {
        if (this.state == null) {
            return;
        }
        this.state.terminate();
        this.state = null;
    }

    private List<String> stripIndent(List<String> lines) {
        String first = lines.remove(0);
        int indent = this.getIndent(lines);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.length() < indent) continue;
            line = line.substring(indent);
            lines.set(i, line);
        }
        lines.add(0, first);
        return lines;
    }

    private int getIndent(List<String> lines) {
        int indent = Integer.MAX_VALUE;
        for (String line : lines) {
            Matcher matcher;
            if (line.length() == 0 || !(matcher = this.leadingSpaces.matcher(line)).find()) continue;
            String spaces = matcher.group(1);
            indent = Math.min(indent, spaces.length());
        }
        return indent;
    }

    private class ReadingBullet
    implements State {
        private final List<String> lines = new ArrayList<String>();
        private final Pattern continued;

        public ReadingBullet(String bullet) {
            String spaces = bullet.replaceAll(".", " ");
            this.continued = Pattern.compile(String.format("^%s(.+)", spaces));
        }

        @Override
        public void process(String line) {
            this.lines.add(line);
        }

        @Override
        public void terminate() {
            String content = Join.join((String)" ", this.lines).replaceAll("  +", " ");
            DocumentParser.this.doc.bullet(content);
        }
    }

    private class ReadingPreformatted
    implements State {
        private final List<String> lines = new ArrayList<String>();

        private ReadingPreformatted() {
        }

        @Override
        public void process(String line) {
            this.lines.add(line);
        }

        @Override
        public void terminate() {
            DocumentParser.this.doc.preformatted(Join.join((String)"\n", this.lines));
        }
    }

    private class ReadingParagraph
    implements State {
        private final List<String> lines = new ArrayList<String>();

        private ReadingParagraph() {
        }

        @Override
        public void process(String line) {
            this.lines.add(line.trim());
        }

        @Override
        public void terminate() {
            String content = Join.join((String)" ", this.lines).replaceAll("  +", " ");
            DocumentParser.this.doc.paragraph(content);
        }
    }

    public static interface State {
        public void process(String var1);

        public void terminate();
    }
}

