/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.help;

import java.util.ArrayList;
import java.util.List;
import org.tomitribe.crest.help.Bullet;
import org.tomitribe.crest.help.Element;
import org.tomitribe.crest.help.Heading;
import org.tomitribe.crest.help.Paragraph;
import org.tomitribe.crest.help.Preformatted;

public class Document {
    final List<Element> elements = new ArrayList<Element>();

    private Document(List<Element> elements) {
        this.elements.addAll(elements);
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        final List<Element> elements = new ArrayList<Element>();

        public Builder paragraph(String content) {
            this.elements.add(new Paragraph(content));
            return this;
        }

        public Builder bullet(String content) {
            this.elements.add(new Bullet(content));
            return this;
        }

        public Builder preformatted(String content) {
            this.elements.add(new Preformatted(content));
            return this;
        }

        public Builder heading(String content) {
            this.elements.add(new Heading(content));
            return this;
        }

        public Builder inline(Document document) {
            this.elements.addAll(document.elements);
            return this;
        }

        public Builder element(Element element) {
            this.elements.add(element);
            return this;
        }

        public Document build() {
            return new Document(this.elements);
        }
    }
}

