/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.tomitribe.crest.Main;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.api.Option;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CmdGroup;
import org.tomitribe.crest.cmds.CmdMethod;
import org.tomitribe.crest.cmds.OverloadedCmdMethod;
import org.tomitribe.crest.cmds.processors.Commands;
import org.tomitribe.crest.cmds.processors.OptionParam;
import org.tomitribe.crest.environments.Environment;
import org.tomitribe.util.IO;
import org.tomitribe.util.Join;
import org.tomitribe.util.PrintString;

public class BashCompletion {
    private static final String COMPLETER = "_completer";
    final PrintString out = new PrintString();
    private final Main main;
    private String mainCommand;

    public BashCompletion(Main main) {
        this.main = main;
    }

    @Command(value="_completer")
    public String _completer(@Option(value={"f"}) boolean toFile) {
        return this._completer(toFile, this.guessName());
    }

    @Command(value="_completer")
    public String _completer(@Option(value={"f"}) boolean toFile, String name) {
        this.mainCommand = name;
        this.out.println("#!/bin/bash\n");
        this.utilities();
        this.group(2, "_" + this.mainCommand, this.main.commands.values());
        this.out.println("\ncomplete -F _" + this.mainCommand + " " + this.mainCommand);
        if (toFile) {
            return this.asFile();
        }
        return this.out.toString();
    }

    private String asFile() {
        try {
            File file = File.createTempFile(String.format(".%s-completion-", this.mainCommand), ".sh");
            IO.copy((byte[])this.out.toByteArray(), (File)file);
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate completion script for " + this.mainCommand, e);
        }
    }

    private String getMainCommandName(String ... args) {
        if (args.length == 1) {
            return this.asFilename(args[0]);
        }
        return this.guessName();
    }

    private String guessName() {
        String name = System.getProperty("cmd");
        if (name != null) {
            return this.asFilename(name);
        }
        name = System.getenv("CMD");
        if (name != null) {
            return this.asFilename(name);
        }
        Environment env = Environment.ENVIRONMENT_THREAD_LOCAL.get();
        PrintStream error = env.getError();
        error.println("Specify the bash executable name.  Acceptable methods in order of priority:\n 1. passed as an argument to this command (e.g. _completion wombat)\n 2. set via a -Dcmd system property (e.g. java -Dcmd=wombat, e.g. java -Dcmd=/some/path/wombat)\n 3. set as a $CMD environment variable (e.g. export CMD=$0, e.g. export CMD=wombat, e.g. export CMD=/some/path/wombat)");
        throw new IllegalStateException("The bash executable name was not found");
    }

    private String asFilename(String name) {
        File file = new File(name);
        return file.getName();
    }

    public static String generate(Main main, String ... args) {
        BashCompletion bashCompletion = new BashCompletion(main);
        Map<String, Cmd> cmds = Commands.get(bashCompletion);
        return (String)cmds.get(COMPLETER).exec(null, args);
    }

    private void cmd(int depth, String group, Cmd cmd) {
        if (cmd instanceof CmdGroup) {
            this.cmdGroup((CmdGroup)cmd, group, depth);
        } else if (cmd instanceof OverloadedCmdMethod) {
            this.overloadedCmdMethod((OverloadedCmdMethod)cmd, group);
        } else if (cmd instanceof CmdMethod) {
            this.cmdMethod((CmdMethod)cmd, group);
        } else {
            throw new IllegalStateException("Unknown cmd type: " + cmd.getClass().getName());
        }
    }

    private void cmdGroup(CmdGroup cmdGroup, String group, int depth) {
        String functionName = this.getFunctionName(group, cmdGroup);
        this.group(depth, functionName, cmdGroup.getCommands());
    }

    private void overloadedCmdMethod(OverloadedCmdMethod overloadedCmdMethod, String group) {
        CmdMethod cmdMethod = overloadedCmdMethod.getMethods().iterator().next();
        this.cmdMethod(cmdMethod, group);
    }

    private void cmdMethod(CmdMethod cmdMethod, String group) {
        String functionName = this.getFunctionName(group, cmdMethod);
        this.out.println("\nfunction " + functionName + "() {");
        CmdMethod.Spec spec = cmdMethod.getSpec();
        if (BashCompletion.hasFlags(spec)) {
            this.proposeFlags(spec);
        } else {
            this.out.println("  _propose_files");
        }
        this.out.println("}");
    }

    private void proposeFlags(CmdMethod.Spec spec) {
        this.out.println("  local cur=${COMP_WORDS[COMP_CWORD]}\n\n  case \"$cur\" in");
        Collection<OptionParam> options = spec.getOptions().values();
        for (OptionParam param : options) {
            List<String> values = this.guessValues(param);
            if (values.size() > 0) {
                List strings = values.stream().map(this::quote).collect(Collectors.toList());
                this.out.printf("  %s*) _propose_flag_values %s ;;\n", new Object[]{this.flag(param.getName()), Join.join((String)" ", strings)});
                continue;
            }
            this.out.printf("  %s*) _propose_flag_file_values ;;\n", new Object[]{this.flag(param.getName())});
        }
        List flags = options.stream().map(OptionParam::getName).map(this::flag).map(this::quote).collect(Collectors.toList());
        this.out.printf("  -*) _propose_flags %s;;\n", new Object[]{Join.join((String)" ", flags)});
        this.out.println("  *) _propose_files ;;\n  esac\n");
    }

    private static boolean hasFlags(CmdMethod.Spec spec) {
        return spec != null && spec.getOptions() != null && spec.getOptions().size() != 0;
    }

    private List<String> guessValues(OptionParam param) {
        List<String> values = BashCompletion.getDefaults(param);
        Class type = param.getType();
        if (type.isPrimitive()) {
            values.remove(0);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            values.add("true");
            values.add("false");
        } else if (Enum.class.isAssignableFrom(type)) {
            Enum[] constants;
            Class enumClass = type;
            for (Enum constant : constants = (Enum[])enumClass.getEnumConstants()) {
                values.add(constant.name());
            }
        } else if (Pattern.class.isAssignableFrom(type) && values.size() == 0) {
            values.add("<regex>");
        } else if (this.isNonFile(type) && values.size() == 0) {
            values.add(String.format("<%s>", type.getSimpleName()));
        }
        return values.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private static List<String> getDefaults(OptionParam param) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(param.getDefaultValue());
        values.addAll(param.getDefaultValues());
        return values.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private boolean isNonFile(Class<?> type) {
        Class[] types;
        for (Class aClass : types = new Class[]{URI.class, URL.class, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE}) {
            if (!aClass.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private String flag(String s) {
        if (s.length() == 1) {
            return String.format("-%s=", s);
        }
        return String.format("--%s=", s);
    }

    private <T> String quote(T t) {
        return "\"" + t + "\"";
    }

    private String getFunctionName(String group, Cmd cmd) {
        String safeCharacters = cmd.getName().replaceAll("[^a-zA-Z0-9]+", "");
        return group + "_" + safeCharacters;
    }

    private void proposeFiles() {
        this.out.println("\nfunction _propose_files() {\n  local cur=${COMP_WORDS[COMP_CWORD]}\n  COMPREPLY=($(compgen -f \"$cur\"))\n}\n");
    }

    private void proposeFlags() {
        this.out.println("\nfunction _propose_flags() {\n  local FLAGS=\"$@\"\n  local cur=${COMP_WORDS[COMP_CWORD]}\n\n  # minus flags we've used\n  for ((i = 0; i < ${#COMP_WORDS[*]} - 1; i++)); do\n    n=\"${COMP_WORDS[$i]}\"\n    [[ \"$n\" == -* ]] && {\n      n=\"${n/=*/=}\"\n      FLAGS=(\"${FLAGS[@]/$n/}\")\n    }\n  done\n\n  COMPREPLY=($(compgen -W \"${FLAGS[*]}\" -- \"$cur\"))\n}\n");
    }

    private void proposeFlagValues() {
        this.out.println("\nfunction _propose_flag_values() {\n  local VALUES=\"$@\"\n  local cur=${COMP_WORDS[COMP_CWORD]}\n\n  cur=\"$(echo \"$cur\" | perl -pe 's/[^=]+=//')\"\n  COMPREPLY=($(compgen -W \"${VALUES[*]}\" \"$cur\"))\n}\n");
    }

    private void proposeFlagValuesFiles() {
        this.out.println("\nfunction _propose_flag_file_values() {\n  local cur=${COMP_WORDS[COMP_CWORD]}\n\n  cur=\"$(echo \"$cur\" | perl -pe 's/[^=]+=//')\"\n  COMPREPLY=($(compgen -f \"$cur\"))\n}\n");
    }

    private void utilities() {
        this.proposeFiles();
        this.proposeFlags();
        this.proposeFlagValues();
        this.proposeFlagValuesFiles();
    }

    private void group(int depth, String functionName, Collection<Cmd> commands) {
        int depthPlusOne = depth + 1;
        int depthMinusOne = depth - 1;
        List names = commands.stream().map(Cmd::getName).map(s -> "    " + s).collect(Collectors.toList());
        this.out.println("function " + functionName + "() {\n  local cur=${COMP_WORDS[COMP_CWORD]}\n  local args_length=${#COMP_WORDS[@]}\n\n  local COMMANDS=(\n" + Join.join((String)"\n", names) + "\n  )\n\n  # List the commands\n  [ $args_length -lt " + depthPlusOne + " ] && {\n    COMPREPLY=($(compgen -W \"${COMMANDS[*]}\" \"$cur\"))\n    return\n  }\n\n  # Command chosen.  Delegate to its completion function\n\n  # Verify the command is one we know and execute the\n  # function that performs its completion\n  local CMD=${COMP_WORDS[" + depthMinusOne + "]}\n  for n in \"${COMMANDS[@]}\"; do\n    [ \"$CMD\" = \"$n\" ] && {\n      CMD=\"$(echo \"$CMD\" | perl -pe 's,[^a-zA-Z0-9],,g')\"\n      " + functionName + "_$CMD\n      return\n    }\n  done\n\n  COMPREPLY=()\n}\n");
        for (Cmd cmd : commands) {
            this.cmd(depthPlusOne, functionName, cmd);
        }
    }
}

