/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cli.impl.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.api.Default;
import org.tomitribe.crest.api.In;
import org.tomitribe.crest.api.Option;
import org.tomitribe.crest.api.Out;
import org.tomitribe.crest.cli.impl.command.JSonP;
import org.tomitribe.util.IO;

public class Streams {
    @Command
    public static void jgrep(String pattern, @Option(value={"regex"}) @Default(value="false") boolean isRegex, final @Option(value={"i"}) @Default(value="true") boolean insensitive, @In InputStream in, @Out PrintStream out) {
        if (pattern == null) {
            throw new NullPointerException("Pattern shouldnt be null");
        }
        ArrayList<1> predicates = new ArrayList<1>();
        for (final String patt : pattern.split("\\|")) {
            predicates.add(isRegex ? new Predicate<String>(){
                private final Pattern pattern;
                {
                    this.pattern = Pattern.compile(patt);
                }

                @Override
                public boolean test(String s) {
                    return this.pattern.matcher(s).matches();
                }
            } : new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return insensitive ? s.toLowerCase(Locale.ENGLISH).contains(patt.toLowerCase(Locale.ENGLISH)) : s.contains(patt);
                }
            });
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            block12: while ((line = reader.readLine()) != null) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(line)) continue;
                    out.println(line);
                    continue block12;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Command
    public static void wc(@Option(value={"l"}) @Default(value="true") boolean line, @Option(value={"c"}) @Default(value="false") boolean characters, @In InputStream in, @Out PrintStream out) {
        int count;
        block32: {
            count = 0;
            if (characters) {
                try (InputStreamReader reader = new InputStreamReader(in);){
                    while (((Reader)reader).read() >= 0) {
                        ++count;
                    }
                    break block32;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (line) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    while (reader.readLine() != null) {
                        ++count;
                    }
                    break block32;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            throw new IllegalStateException("wc needs at least one active option");
        }
        out.println(count);
    }

    @Command
    public static void jsed(String command, @In InputStream in, @Out PrintStream out) {
        if (!Objects.requireNonNull(command, "Please provide an option like: jsed s/foo/bar/g").startsWith("s/")) {
            throw new IllegalArgumentException("Only substitution commands supported.");
        }
        int slash1 = command.indexOf(47);
        int slash2 = command.indexOf(47, slash1 + 1);
        int slash3 = command.indexOf(47, slash2 + 1);
        if (slash1 < 0 || slash2 < 0 || slash3 < 0) {
            throw new IllegalArgumentException("Wrong pattern '" + command + "', use s/pattern/replacement/[g]");
        }
        String pattern = command.substring(slash1 + 1, slash2);
        String substitution = command.substring(slash2 + 1, slash3);
        boolean global = command.endsWith("/g");
        Pattern compiled = Pattern.compile(pattern);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                out.println(global ? compiled.matcher(line).replaceAll(substitution) : compiled.matcher(line).replaceFirst(substitution));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Command
    public static void pretty(@In InputStream in, @Out PrintStream out) throws IOException {
        String content = IO.slurp((InputStream)in);
        if (content.startsWith("{") || content.startsWith("[")) {
            JSonP.format(content, out);
        } else {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                StreamResult result = new StreamResult(new StringWriter());
                transformer.transform(new StreamSource(new StringReader(content)), result);
                out.write(result.getWriter().toString().getBytes("UTF-8"));
            }
            catch (TransformerException e) {
                out.write(content.getBytes("UTF-8"));
            }
        }
        out.write(System.lineSeparator().getBytes());
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Streams() {
    }

    static interface Predicate<T> {
        public boolean test(T var1);
    }
}

