/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.write.questionnaire.helpers;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.domain.questionnaire.framework.ConditionConstants;
import org.tohu.domain.questionnaire.framework.PageElementConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldTypeHelper
implements PageElementConstants,
ConditionConstants {
    private static final Logger logger = LoggerFactory.getLogger(FieldTypeHelper.class);

    public static String formatOperationString(String op) {
        if (op.startsWith("\"") && op.endsWith("\"") && op.length() > 2) {
            op = op.substring(1, op.length() - 2);
        } else if (op.toUpperCase().startsWith("NOOP")) {
            op = "";
        } else if (op.toUpperCase().startsWith("IS NOT")) {
            op = "!=";
        } else if (op.toUpperCase().startsWith("IS")) {
            op = "==";
        }
        return op;
    }

    public static String formatValueStringInLogic(Map<String, String> itemVariables, String valueString) {
        if (valueString == null || valueString.toUpperCase().equals("EMPTY")) {
            return "null";
        }
        if (valueString.indexOf(".") > 0) {
            return valueString;
        }
        String varName = itemVariables.get(valueString);
        if (varName != null) {
            valueString = String.format("%s.answer", varName);
        } else if (!valueString.startsWith("\"")) {
            valueString = "\"" + valueString + "\"";
        }
        return valueString;
    }

    public static String formatValueStringAccordingToType(String tempStr, String type) {
        if (tempStr == null) {
            return null;
        }
        if (type.equals("Text") || type.equals("Date") || type.equals("List")) {
            if (!tempStr.startsWith("\"")) {
                tempStr = "\"" + tempStr + "\"";
            }
        } else if (type.equals("Number")) {
            if (!tempStr.endsWith("L")) {
                tempStr = tempStr + "L";
            }
        } else if (type.equals("Decimal") && !tempStr.endsWith("D")) {
            tempStr = tempStr + "D";
        }
        return tempStr;
    }

    public static String mapFieldTypeToQuestionType(String theFieldType) {
        if (theFieldType == null || theFieldType.equals("Text")) {
            return "Question.TYPE_TEXT";
        }
        if (theFieldType.equals("Boolean")) {
            return "Question.TYPE_BOOLEAN";
        }
        if (theFieldType.equals("Number")) {
            return "Question.TYPE_NUMBER";
        }
        if (theFieldType.equals("Decimal")) {
            return "Question.TYPE_DECIMAL";
        }
        if (theFieldType.equals("Date")) {
            return "Question.TYPE_DATE";
        }
        if (theFieldType.equals("List")) {
            return "Question.TYPE_LIST";
        }
        logger.debug("Converting type: " + theFieldType + " to Text");
        return "Question.TYPE_TEXT";
    }

    public static String mapFieldTypeToBaseVariableName(String theFieldType) {
        if (theFieldType == null || theFieldType.equals("Text")) {
            return "textAnswer";
        }
        if (theFieldType.equals("Number")) {
            return "numberAnswer";
        }
        if (theFieldType.equals("Decimal")) {
            return "decimalAnswer";
        }
        if (theFieldType.equals("Boolean")) {
            return "booleanAnswer";
        }
        if (theFieldType.equals("Date")) {
            return "dateAnswer";
        }
        logger.debug("Converting type: " + theFieldType + " to Text");
        return "textAnswer";
    }

    public static String mapFieldTypeToJavaClassName(String theFieldType) {
        if (theFieldType == null || theFieldType.equals("Text")) {
            return "String";
        }
        if (theFieldType.equals("Number")) {
            return "Long";
        }
        if (theFieldType.equals("Decimal")) {
            return "Double";
        }
        if (theFieldType.equals("Boolean")) {
            return "Boolean";
        }
        if (theFieldType.equals("Date")) {
            return "Date";
        }
        logger.debug("Converting type : " + theFieldType + " to Java Class String");
        return "String";
    }

    public static String mapFieldTypeToJavaNumberClassMethodName(String theFieldType) {
        if (theFieldType == null || theFieldType.equals("Text")) {
            return "toString()";
        }
        if (theFieldType.equals("Number")) {
            return "longValue()";
        }
        if (theFieldType.equals("Decimal")) {
            return "doubleValue()";
        }
        logger.debug("Converting number method type: " + theFieldType + " to Text");
        return "toString()";
    }
}

