/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.write.questionnaire;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.domain.questionnaire.Application;
import org.tohu.domain.questionnaire.Page;
import org.tohu.domain.questionnaire.PageElement;
import org.tohu.write.questionnaire.PageElementTemplate;
import org.tohu.write.questionnaire.helpers.CopyrightWriter;

public class PageTemplate {
    private static final Logger logger = LoggerFactory.getLogger(PageTemplate.class);
    protected Page pg;

    public PageTemplate(Page page) {
        this.pg = page;
    }

    public boolean generateDRLFile(Application application, String directory, String importDirectory, int count, boolean seperatePageDirectories) {
        String pageNumber = String.valueOf(count);
        pageNumber = pageNumber.length() == 1 ? "page0" + pageNumber : "page" + pageNumber;
        String subDirectory = directory + "/" + pageNumber;
        if (!seperatePageDirectories) {
            subDirectory = directory;
        }
        String fileName = subDirectory + "/" + this.pg.getId().replace(' ', '_') + ".drl";
        try {
            File outdir = new File(subDirectory);
            if (outdir.exists() && !outdir.isDirectory()) {
                throw new IOException(subDirectory + " is not a valid directory.");
            }
            if (!outdir.exists() && !outdir.mkdir()) {
                throw new IOException("Unable to create directory: " + subDirectory);
            }
            Formatter fmtFile = new Formatter(new FileOutputStream(fileName));
            CopyrightWriter.writeCopyright(fmtFile, importDirectory);
            this.writeDRLFileContents(application, fmtFile);
            fmtFile.close();
        }
        catch (IOException e) {
            logger.debug(e.getMessage());
            e.printStackTrace();
            return false;
        }
        logger.debug("The " + fileName + " file has been written");
        return true;
    }

    protected void writeDRLForPageElement(Application application, Formatter fmt, PageElement element) throws IOException {
        if (element.isAGroupType()) {
            for (PageElement child : element.getChildren()) {
                child.addGroupId(element.getId());
            }
        }
        new PageElementTemplate(element).writeDRLFileContents(application, fmt);
        for (PageElement child : element.getChildren()) {
            this.writeDRLForPageElement(application, fmt, child);
        }
    }

    protected void writeDRLFileContents(Application application, Formatter fmt) throws IOException {
        fmt.format("package %s.%s;\n\n", application.getApplicationClass(), this.pg.getSheetName().replace(' ', '_').toLowerCase());
        fmt.format("import java.util.Calendar;\n", new Object[0]);
        fmt.format("import org.tohu.Group;\n", new Object[0]);
        fmt.format("import org.tohu.InvalidAnswer;\n", new Object[0]);
        fmt.format("import org.tohu.MultipleChoiceQuestion;\n", new Object[0]);
        fmt.format("import org.tohu.MultipleChoiceQuestion.PossibleAnswer;\n", new Object[0]);
        fmt.format("import org.tohu.Note;\n", new Object[0]);
        fmt.format("import org.tohu.Question;\n", new Object[0]);
        fmt.format("import org.tohu.Answer;\n", new Object[0]);
        fmt.format("import org.tohu.Questionnaire;\n", new Object[0]);
        fmt.format("import org.tohu.support.TohuDataItemObject;\n\n", new Object[0]);
        fmt.format("import %s.*;\n\n", application.getApplicationClass());
        if (this.pg.getElements() != null && this.pg.getElements().size() > 0) {
            this.writeDRLForPageElement(application, fmt, this.pg.getElements().get(0));
        }
    }
}

