/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.spreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.tohu.load.spreadsheet.CellIdentifier;

public class SpreadsheetItem {
    private CellIdentifier cellIdentifier;
    private Cell spreadsheetCell;
    private String sheetName;
    private int column;
    private int row;

    public SpreadsheetItem(String sheetName, Cell cell) {
        this.sheetName = sheetName;
        this.spreadsheetCell = cell;
        this.column = this.spreadsheetCell.getColumnIndex();
        this.row = this.spreadsheetCell.getRowIndex();
        this.cellIdentifier = new CellIdentifier(this.sheetName, this.spreadsheetCell.getRowIndex(), this.column);
    }

    public String getCellIdentifier() {
        return this.cellIdentifier.getCellIdentifier();
    }

    public String toString() {
        return this.spreadsheetCell.toString();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public Cell getSpreadsheetCell() {
        return this.spreadsheetCell;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }
}

