/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.questionnaire;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.domain.questionnaire.Application;
import org.tohu.domain.questionnaire.Page;
import org.tohu.load.questionnaire.ExtractItems;
import org.tohu.load.questionnaire.SpreadsheetSectionConstants;
import org.tohu.load.spreadsheet.SpreadsheetRow;
import org.tohu.load.spreadsheet.sections.SpreadsheetSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractPages
implements SpreadsheetSectionConstants {
    private static final Logger logger = LoggerFactory.getLogger(ExtractPages.class);
    private Application application;
    private List<SpreadsheetSection> data;
    protected Page currentPage;
    protected String currentSheetName;

    public ExtractPages(List<SpreadsheetSection> theData, Application theApplication) {
        this.data = theData;
        this.application = theApplication;
    }

    public boolean processPages() {
        for (SpreadsheetSection section : this.data) {
            if (section.isProcessed() || this.processSectionData(section)) continue;
            logger.debug("Failed to process section " + section.getSectionHeadingString() + " for sheet " + section.getSheetName());
            return false;
        }
        return true;
    }

    protected boolean processSectionData(SpreadsheetSection section) {
        List<SpreadsheetRow> rows = section.getSectionRows();
        this.currentSheetName = section.getSheetName();
        if (section.getSectionHeadingString().startsWith("ITEM ID")) {
            this.currentPage = new ExtractItems(this.application, this.currentPage).processSectionData(section);
            if (this.currentPage == null) {
                logger.debug("Warning: no current page returned for section. " + section.toString());
                return true;
            }
            return true;
        }
        for (SpreadsheetRow spreadsheetRow : rows) {
            if (spreadsheetRow.getRowItems().size() == 0 || !section.getSectionHeadingString().startsWith("END")) continue;
            logger.debug("Did not expect to be processing a Sheet End section - ignoring!");
            break;
        }
        return true;
    }
}

