/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.domain.questionnaire.Application;
import org.tohu.domain.questionnaire.LookupTable;
import org.tohu.domain.questionnaire.conditions.ConditionClause;
import org.tohu.load.questionnaire.SpreadsheetSectionConstants;
import org.tohu.load.spreadsheet.SpreadsheetItem;
import org.tohu.load.spreadsheet.SpreadsheetRow;
import org.tohu.load.spreadsheet.sections.SpreadsheetSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractApplication
implements SpreadsheetSectionConstants {
    private static final Logger logger = LoggerFactory.getLogger(ExtractApplication.class);
    private Application application = new Application();
    private SpreadsheetSection applicationSection;
    private List<SpreadsheetSection> tableSections = new ArrayList<SpreadsheetSection>();
    private LookupTable currentLookupTable;

    public ExtractApplication(List<SpreadsheetSection> sections) {
        for (SpreadsheetSection spreadsheetSection : sections) {
            if (spreadsheetSection.getSectionHeadingString().startsWith("APPSET")) {
                this.applicationSection = spreadsheetSection;
                continue;
            }
            if (!spreadsheetSection.getSectionHeadingString().startsWith("LISTS")) continue;
            this.tableSections.add(spreadsheetSection);
        }
        if (this.applicationSection == null) {
            throw new IllegalArgumentException("There was no section heading with APPSET found");
        }
    }

    public Application processApp() {
        List<SpreadsheetRow> rows = this.applicationSection.getSectionRows();
        if (rows.isEmpty()) {
            return null;
        }
        for (SpreadsheetRow spreadsheetRow : rows) {
            this.processApplicationHeadingLine(this.applicationSection.getHeaderRow(), spreadsheetRow);
        }
        this.applicationSection.setProcessed(true);
        for (SpreadsheetSection ts : this.tableSections) {
            rows = ts.getSectionRows();
            if (rows.isEmpty()) continue;
            for (SpreadsheetRow spreadsheetRow : rows) {
                this.processListLine(ts.getHeaderRow(), spreadsheetRow);
            }
            ts.setProcessed(true);
        }
        return this.application;
    }

    protected void processApplicationHeadingLine(SpreadsheetRow headings, SpreadsheetRow row) {
        for (SpreadsheetItem item : row.getRowItems()) {
            String key = headings.getHeaderTextForColumnInUpperCase(item.getColumn());
            if (key == null) continue;
            String value = item.toString();
            if (key.startsWith("APPSET")) {
                if (this.application.getId() != null) {
                    throw new IllegalStateException("You cannot have two rows with an application id!");
                }
                this.application.setId(value);
                continue;
            }
            if (key.startsWith("BASE")) {
                this.application.setApplicationClass(value);
                continue;
            }
            if (key.equals("NAME")) {
                this.application.setApplicationName(value);
                continue;
            }
            if (key.equals("COMPLETION")) {
                this.application.setCompletionAction(value);
                continue;
            }
            if (key.startsWith("NOTE")) {
                this.application.setNote(value);
                continue;
            }
            if (key.startsWith("ACTIVE")) {
                this.application.setActivePage(value);
                continue;
            }
            if (key.startsWith("INCLUDE")) {
                this.application.addImport(value);
                continue;
            }
            if (key.startsWith("ACTION")) {
                this.application.setActionValidation(value);
                continue;
            }
            if (key.startsWith("MARKUP")) {
                this.application.setMarkupAllowed(value);
                continue;
            }
            logger.debug("Unknown Application key: " + key);
        }
    }

    protected void processListLine(SpreadsheetRow headings, SpreadsheetRow row) {
        String itemValue = null;
        String displayedValue = null;
        String itemName = null;
        String attributeName = null;
        String operation = null;
        String rhs = null;
        for (SpreadsheetItem item : row.getRowItems()) {
            String key = headings.getHeaderTextForColumnInUpperCase(item.getColumn());
            if (key == null) continue;
            String value = item.toString();
            if (key.startsWith("LISTS")) {
                this.currentLookupTable = new LookupTable(value);
                this.application.addLookupTable(this.currentLookupTable);
                continue;
            }
            if (key.startsWith("ACTUAL")) {
                itemValue = value;
                continue;
            }
            if (key.startsWith("DISPLAY")) {
                displayedValue = value;
                continue;
            }
            if (key.startsWith("DEPENDS")) {
                itemName = value;
                continue;
            }
            if (key.startsWith("ATTRIBUTE")) {
                attributeName = value;
                continue;
            }
            if (key.startsWith("OP")) {
                operation = value;
                continue;
            }
            if (key.startsWith("VALUE")) {
                rhs = value;
                continue;
            }
            logger.debug("Unknown List key: " + key);
        }
        ConditionClause cc = null;
        if (itemName != null) {
            if (itemValue == null) {
                throw new IllegalArgumentException("You cannot (yet) have more than one logic element for a list entry");
            }
            cc = new ConditionClause(itemName, attributeName, operation, rhs);
        }
        if (displayedValue == null) {
            this.currentLookupTable.addEntry(itemValue, cc);
        } else {
            this.currentLookupTable.addEntry(itemValue, displayedValue, cc);
        }
    }
}

