/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.domain.questionnaire.conditions;

import java.util.ArrayList;
import java.util.List;
import org.tohu.domain.questionnaire.conditions.ConditionClause;
import org.tohu.domain.questionnaire.framework.ConditionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageElementCondition
implements ConditionConstants,
Cloneable {
    public static final String TYPE_VALIDATION = "Validation";
    public static final String TYPE_INCLUSION = "Inclusion";
    protected String id;
    protected String idPrefix;
    protected List<ConditionClause> elements = new ArrayList<ConditionClause>();
    protected int rowNumber;
    protected String type;
    private String pageName;
    private boolean branchedPage;
    private String displayAfter;

    public PageElementCondition(String type, String id, int rowNumber) {
        this(type, id, rowNumber, null, false, null);
    }

    public PageElementCondition(String sheetName, String id, int rowNumber, String pageName, boolean branchedPage, String displayAfter) {
        id = id.trim();
        if (id.indexOf(" ") >= 0) {
            throw new IllegalArgumentException("You cannot have a space in an id [" + id + "]");
        }
        if (this.type == null) {
            this.type = TYPE_INCLUSION;
        }
        this.id = id;
        this.idPrefix = this.type + "_" + String.valueOf(rowNumber);
        this.rowNumber = rowNumber;
        this.pageName = pageName;
        this.branchedPage = branchedPage;
        this.displayAfter = displayAfter;
    }

    public Object clone() throws CloneNotSupportedException {
        PageElementCondition newFact = (PageElementCondition)super.clone();
        this.pageName = null;
        this.branchedPage = false;
        this.displayAfter = null;
        return newFact;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public void addElement(ConditionClause element) {
        this.elements.add(element);
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public List<ConditionClause> getElements() {
        return this.elements;
    }

    public String getType() {
        return this.type;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean isBranchedPage() {
        return this.branchedPage;
    }

    public String getDisplayAfter() {
        return this.displayAfter;
    }
}

