/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.write.questionnaire;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import org.tohu.domain.questionnaire.Application;
import org.tohu.domain.questionnaire.PageElement;
import org.tohu.domain.questionnaire.conditions.ConditionClause;
import org.tohu.domain.questionnaire.conditions.PageElementCondition;
import org.tohu.domain.questionnaire.framework.ConditionConstants;
import org.tohu.write.questionnaire.helpers.FieldTypeHelper;

public class WhenClauseTemplate
implements ConditionConstants {
    private PageElementCondition condition = null;
    private PageElement element = null;

    public WhenClauseTemplate(PageElement element) {
        this.element = element;
        this.condition = element.getDisplayCondition();
    }

    public void writeLogicSectionDRLFileContents(Application application, Formatter fmt, boolean splitQuestionValuesIntoQuestionAndAnswer) throws IOException {
        PageElement lastItem = null;
        int count = 0;
        boolean alreadySplitAnswerOut = false;
        if (this.condition == null) {
            throw new IllegalStateException("There is no display condition for " + this.element.getId() + " " + (this.element.getRowNumber() + 1));
        }
        if (this.condition.getElements() == null) {
            throw new IllegalStateException("There is no display condition elements for " + this.element.getId() + " " + (this.element.getRowNumber() + 1));
        }
        HashMap<String, String> itemVariables = new HashMap<String, String>();
        for (ConditionClause element : this.condition.getElements()) {
            PageElement pgElement;
            boolean sameItem;
            String seperator = ", ";
            ++count;
            String itemId = element.getItemId();
            String attributeName = element.getItemAttribute();
            String valueString = element.getValue();
            String op = element.getOperation();
            if (op == null) {
                op = "==";
            }
            boolean bl = sameItem = lastItem != null && lastItem.getId().equals(itemId);
            if (!sameItem && lastItem != null) {
                lastItem = null;
                fmt.format(");\n", new Object[0]);
            }
            PageElement pageElement = pgElement = sameItem ? lastItem : application.findPageElement(itemId);
            if (op.toUpperCase().startsWith("IS CHANGED TO")) {
                if (!alreadySplitAnswerOut) {
                    splitQuestionValuesIntoQuestionAndAnswer = true;
                }
                op = "IS";
            } else if (op.toUpperCase().startsWith("IS CHANGED FROM")) {
                if (!alreadySplitAnswerOut) {
                    splitQuestionValuesIntoQuestionAndAnswer = true;
                }
                op = "IS NOT";
            }
            if (pgElement != null) {
                if (lastItem == null) {
                    String varName = String.format("pe%d", count);
                    itemVariables.put(itemId, varName);
                    if (!itemId.startsWith("\"")) {
                        itemId = "\"" + itemId + "\"";
                    }
                    fmt.format("\t%s : %s(id == %s ", varName, pgElement.getType(), itemId);
                    lastItem = pgElement;
                }
                if (op.toUpperCase().startsWith("MAPPED")) {
                    fmt.format("%s%s : %s", seperator, attributeName, valueString);
                    continue;
                }
            } else {
                if (op.toUpperCase().startsWith("EVAL")) {
                    if (!itemId.startsWith("eval")) {
                        itemId = "eval(" + itemId + ")";
                    }
                    fmt.format("\t%s %s;\n", itemId, valueString == null ? "" : valueString);
                    continue;
                }
                fmt.format("\t%s", itemId);
            }
            if (attributeName.equals("answer") && splitQuestionValuesIntoQuestionAndAnswer) {
                fmt.format(" );\n\tAnswer (questionId == pe%d.id ", count);
                attributeName = "value";
                splitQuestionValuesIntoQuestionAndAnswer = false;
                alreadySplitAnswerOut = true;
            }
            op = FieldTypeHelper.formatOperationString(op);
            valueString = FieldTypeHelper.formatValueStringInLogic(itemVariables, valueString);
            fmt.format("%s%s %s %s", seperator, attributeName, op, valueString);
            if (lastItem != null) continue;
            fmt.format("\n", new Object[0]);
        }
        if (lastItem != null) {
            lastItem = null;
            fmt.format(");\n", new Object[0]);
        }
    }
}

