/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.write.questionnaire;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Formatter;
import org.tohu.domain.questionnaire.Application;
import org.tohu.domain.questionnaire.Page;
import org.tohu.domain.questionnaire.PageElement;
import org.tohu.domain.questionnaire.conditions.PageElementCondition;
import org.tohu.domain.questionnaire.framework.ListEntryTuple;
import org.tohu.write.questionnaire.PageElementTemplate;
import org.tohu.write.questionnaire.PageTemplate;
import org.tohu.write.questionnaire.WhenClauseTemplate;
import org.tohu.write.questionnaire.helpers.CopyrightWriter;

public class ApplicationTemplate {
    private Application app = null;

    public ApplicationTemplate(Application application) {
        this.app = application;
    }

    public boolean generateDRLFile(String directory, String importDirectory, boolean seperatePageDirectories) {
        String fileName = directory + "/" + this.app.getId().replace(' ', '_') + ".drl";
        try {
            File outdir = new File(directory);
            if (outdir.exists() && !outdir.isDirectory()) {
                throw new IOException(directory + " is not a valid directory.");
            }
            if (!outdir.exists() && !outdir.mkdir()) {
                throw new IOException("Unable to create directory: " + directory);
            }
            Formatter fmtFile = new Formatter(new FileOutputStream(fileName));
            CopyrightWriter.writeCopyright(fmtFile, importDirectory);
            this.writeDRLFileContents(fmtFile);
            if (importDirectory != null) {
                File importDir = new File(importDirectory);
                if (!importDir.exists()) {
                    throw new IOException("Unable to access import directory: " + importDirectory);
                }
                if (!importDirectory.endsWith("/") || !importDirectory.endsWith("\\")) {
                    importDirectory = importDirectory + "/";
                }
                for (String importFileName : this.app.getImports()) {
                    File importFile = new File(importDirectory + importFileName);
                    if (!importFile.exists()) {
                        throw new IOException("The import file does not exist: " + importDirectory + importFileName);
                    }
                    BufferedReader reader = new BufferedReader(new FileReader(importFile));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        fmtFile.format("%s\n", line);
                    }
                    reader.close();
                }
            }
            fmtFile.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        System.out.println("The " + fileName + " file has been written");
        int count = 1;
        for (Page pg : this.app.getPageList()) {
            boolean processed = new PageTemplate(pg).generateDRLFile(this.app, directory, importDirectory, count, seperatePageDirectories);
            if (!processed) {
                return false;
            }
            ++count;
        }
        return true;
    }

    public void writeDRLFileContents(Formatter fmt) throws IOException {
        fmt.format("package %s;\n\n", this.app.getApplicationClass());
        fmt.format("import org.tohu.Group;\n", new Object[0]);
        fmt.format("import org.tohu.InvalidAnswer;\n", new Object[0]);
        fmt.format("import org.tohu.MultipleChoiceQuestion;\n", new Object[0]);
        fmt.format("import org.tohu.MultipleChoiceQuestion.PossibleAnswer;\n", new Object[0]);
        fmt.format("import org.tohu.Note;\n", new Object[0]);
        fmt.format("import org.tohu.Question;\n", new Object[0]);
        fmt.format("import org.tohu.Answer;\n", new Object[0]);
        fmt.format("import org.tohu.Questionnaire;\n", new Object[0]);
        fmt.format("import org.tohu.support.TohuDataItemObject;\n\n", new Object[0]);
        fmt.format("import java.text.SimpleDateFormat;\n", new Object[0]);
        fmt.format("import java.util.Calendar;\n", new Object[0]);
        fmt.format("import java.util.Date;\n", new Object[0]);
        fmt.format("import java.util.Arrays;\n\n", new Object[0]);
        fmt.format("rule \"%s\"\ndialect \"mvel\"\n", this.app.getId());
        fmt.format("then\n", new Object[0]);
        fmt.format("\tQuestionnaire questionnaire = new Questionnaire(\"%s\");\n", this.app.getId());
        fmt.format("\tquestionnaire.setLabel(\"%s\");\n", this.app.getApplicationName());
        fmt.format("\tquestionnaire.setCompletionAction(\"%s\");\n", this.app.getCompletionAction());
        fmt.format("\tquestionnaire.setItems({%s});\n", this.app.getItemList());
        if (this.app.getActivePage() != null) {
            fmt.format("\tquestionnaire.setActiveItem(\"%s\");\n", this.app.getActivePage());
        }
        fmt.format("\tquestionnaire.setEnableActionValidation(%s);\n", this.app.getActionValidation());
        fmt.format("\tinsertLogical(questionnaire);\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
        for (PageElement element : this.app.getGlobalElements()) {
            new PageElementTemplate(element).writeDRLFileContents(this.app, fmt);
        }
        fmt.format("declare ListEntryFact\n", new Object[0]);
        fmt.format("\tid : String @key\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
        for (Page pg : this.app.getPageList()) {
            this.processConditionalTableElement(fmt, pg.getParentPageElement());
        }
    }

    protected void processConditionalTableElement(Formatter fmt, PageElement element) throws IOException {
        if (element == null) {
            return;
        }
        if (element.getLookupTable() != null && element.getLookupTable().getEntries() != null) {
            int count = 0;
            for (ListEntryTuple tuple : element.getLookupTable().getEntries()) {
                ++count;
                if (tuple.getConditionClause() == null) continue;
                this.writeConditionalTableElement(fmt, element, tuple, count);
            }
        }
        for (PageElement child : element.getChildren()) {
            this.processConditionalTableElement(fmt, child);
        }
    }

    protected void writeConditionalTableElement(Formatter fmt, PageElement element, ListEntryTuple tuple, int rowNumber) throws IOException {
        String displayFactId = element.getId() + "row" + String.valueOf(rowNumber);
        fmt.format("rule \"Trigger %s\"\n", displayFactId);
        fmt.format("salience 50\n", new Object[0]);
        fmt.format("when\n", new Object[0]);
        PageElementCondition c = new PageElementCondition("Inclusion", displayFactId, rowNumber);
        c.addElement(tuple.getConditionClause());
        PageElement pe = new PageElement();
        pe.setId(element.getId(), -1, rowNumber);
        pe.setDisplayCondition(c);
        new WhenClauseTemplate(pe).writeLogicSectionDRLFileContents(this.app, fmt, false);
        fmt.format("then\n", new Object[0]);
        fmt.format("\tListEntryFact lef = new ListEntryFact();\n", new Object[0]);
        fmt.format("\tlef.setId(\"%s\");\n", displayFactId);
        fmt.format("\tinsertLogical(lef);\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
        fmt.format("rule \"Include %s\"\n", displayFactId);
        fmt.format("salience 25\n", new Object[0]);
        fmt.format("no-loop\n", new Object[0]);
        fmt.format("when\n", new Object[0]);
        fmt.format("\tlef : ListEntryFact(id == \"%s\")\n", displayFactId);
        fmt.format("\tmcq : MultipleChoiceQuestion(id == \"%s\")\n", element.getId());
        fmt.format("\teval(!mcq.hasPossibleAnswer(\"%s\"))\n", tuple.getId());
        fmt.format("then\n", new Object[0]);
        fmt.format("\tmcq.insertPossibleAnswer(new PossibleAnswer(\"%s\", \"%s\"), %d);\n", tuple.getId(), tuple.getRepresentation(), rowNumber);
        fmt.format("\tupdate(mcq);\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
        fmt.format("rule \"Remove %s\"\n", displayFactId);
        fmt.format("salience 15\n", new Object[0]);
        fmt.format("no-loop\n", new Object[0]);
        fmt.format("when\n", new Object[0]);
        fmt.format("\tnot lef : ListEntryFact(id == \"%s\")\n", displayFactId);
        fmt.format("\tmcq : MultipleChoiceQuestion(id == \"%s\")\n", element.getId());
        fmt.format("\teval(mcq.hasPossibleAnswer(\"%s\"))\n", tuple.getId());
        fmt.format("then\n", new Object[0]);
        fmt.format("\tmcq.removePossibleAnswer(\"%s\");\n", tuple.getId());
        fmt.format("\tupdate(mcq);\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
    }
}

