/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.spreadsheet.sections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.tohu.load.spreadsheet.SpreadsheetData;
import org.tohu.load.spreadsheet.SpreadsheetItem;
import org.tohu.load.spreadsheet.SpreadsheetRow;
import org.tohu.load.spreadsheet.WorkbookData;
import org.tohu.load.spreadsheet.sections.SpreadsheetSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetSectionSplitter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SpreadsheetSection> sections = new ArrayList<SpreadsheetSection>();
    private List<String> sectionHeadings = new ArrayList<String>();
    private SpreadsheetSection currentSection = new SpreadsheetSection("Initialize", "END", new SpreadsheetRow(0));

    public SpreadsheetSectionSplitter(String[] headings) {
        for (int i = 0; i < headings.length; ++i) {
            String string = headings[i];
            this.sectionHeadings.add(string.toUpperCase());
        }
    }

    public void cleanUpRowItemStrings(SpreadsheetRow row) {
        char c2 = '\u2026';
        String tempCharStr = new String(new char[]{c2});
        for (SpreadsheetItem item : row.getRowItems()) {
            String tempStr = item.getSpreadsheetCell().toString();
            int pos = tempStr.indexOf(c2);
            if (pos < 0) continue;
            tempStr = tempStr.replaceAll(tempCharStr, "&#8230;");
            item.getSpreadsheetCell().setCellValue(tempStr);
        }
    }

    public List<SpreadsheetSection> splitIntoSections(WorkbookData wbData) {
        for (String sheetName : wbData.getSheetList()) {
            SpreadsheetData sheetData = wbData.getSheet(sheetName);
            if (sheetData.isProcessed() || sheetData.getFirstItemOnSheet() == null || sheetData.getFirstItemOnSheet().toString().toUpperCase().startsWith("END")) continue;
            List<SpreadsheetRow> rows = sheetData.getRows();
            if (rows.isEmpty()) {
                sheetData.setProcessed(true);
                continue;
            }
            for (SpreadsheetRow spreadsheetRow : rows) {
                if (spreadsheetRow.getRowItems().size() == 0) continue;
                this.cleanUpRowItemStrings(spreadsheetRow);
                SpreadsheetSection newSection = this.currentSection.processSectionRow(sheetName, spreadsheetRow, this.sectionHeadings);
                if (newSection == null) continue;
                if (newSection.getSectionHeadingString().toUpperCase().startsWith("END")) break;
                this.sections.add(newSection);
                this.currentSection = newSection;
            }
            sheetData.setProcessed(true);
        }
        return this.sections;
    }
}

