/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.spreadsheet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tohu.load.spreadsheet.SpreadsheetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int rowNumber;
    private boolean headerRow = false;
    private Map<Integer, Integer> headerRowColumns = null;
    private List<SpreadsheetItem> rowItems = new ArrayList<SpreadsheetItem>();

    public SpreadsheetRow(int row) {
        this.rowNumber = row;
    }

    public void addRowItem(SpreadsheetItem item) {
        if (this.headerRow) {
            this.headerRowColumns.put(new Integer(item.getColumn()), new Integer(this.rowItems.size()));
        }
        this.rowItems.add(item);
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public List<SpreadsheetItem> getRowItems() {
        return this.rowItems;
    }

    public boolean isHeaderRow() {
        return this.headerRow;
    }

    public void setHeaderRow(boolean headerRow) {
        if (this.headerRow && headerRow) {
            return;
        }
        this.headerRow = headerRow;
        if (!this.headerRow) {
            this.headerRowColumns = null;
        } else {
            this.headerRowColumns = new HashMap<Integer, Integer>(this.rowItems.size());
            int count = 0;
            for (SpreadsheetItem item : this.rowItems) {
                this.headerRowColumns.put(new Integer(item.getColumn()), new Integer(count));
                ++count;
            }
        }
    }

    public SpreadsheetItem getHeaderEntryForColumn(int column) {
        if (!this.headerRow) {
            throw new UnsupportedOperationException("Cannot access a header column when the record is not a header column");
        }
        Integer i = this.headerRowColumns.get(new Integer(column));
        if (i == null) {
            return null;
        }
        return this.rowItems.get(i);
    }

    public String getHeaderTextForColumnInUpperCase(int column) {
        SpreadsheetItem item = this.getHeaderEntryForColumn(column);
        return item.getSpreadsheetCell().toString().toUpperCase();
    }

    public int firstColumnWithAnEntry() {
        if (this.rowItems.size() == 0) {
            return -1;
        }
        return this.rowItems.get(0).getColumn();
    }

    public SpreadsheetItem itemForFirstHeaderColumn(SpreadsheetRow headerRow) {
        int firstColumn = headerRow.firstColumnWithAnEntry();
        for (SpreadsheetItem item : this.rowItems) {
            if (item.getColumn() != firstColumn) continue;
            return item;
        }
        return null;
    }
}

