/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.domain.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.tohu.domain.questionnaire.LookupTable;
import org.tohu.domain.questionnaire.conditions.ConditionClause;
import org.tohu.domain.questionnaire.conditions.PageElementCondition;
import org.tohu.domain.questionnaire.framework.PageElementConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageElement
implements PageElementConstants {
    private String id;
    private List<String> groupIds = null;
    private String type;
    private String lookupTableId;
    private boolean required = false;
    private String fieldType;
    private String preLabel;
    private String postLabel;
    private String defaultValueStr;
    private List<String> styles = new ArrayList<String>();
    private LookupTable lookupTable = null;
    private boolean aPageElement;
    private String pageType = null;
    private String spreadsheetType = null;
    private PageElementCondition displayCondition = null;
    private PageElementCondition currentValidationCondition = null;
    private String category = null;
    private int depth;
    private int rowNumber;
    private ConditionClause logicElement = null;
    protected List<PageElement> children = new ArrayList<PageElement>();
    protected PageElement parent = null;
    protected PageElement previousSibling = null;

    public void setId(String id, int depth, int rowNumber) {
        if ((id = id.trim()).indexOf(" ") >= 0) {
            throw new IllegalArgumentException("You cannot have a space in an id [" + id + "]");
        }
        this.id = id;
        this.depth = depth;
        this.rowNumber = rowNumber;
    }

    public PageElement getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(PageElement previousSibling) {
        this.previousSibling = previousSibling;
    }

    public boolean isAFunctionImpactItem() {
        return this.spreadsheetType != null && this.spreadsheetType.equalsIgnoreCase("FunctionImpact");
    }

    public boolean isAnAlternateImpactItem() {
        return this.spreadsheetType != null && this.spreadsheetType.equalsIgnoreCase("AlternateImpact");
    }

    public boolean isAQuestionType() {
        return this.getType().equals("Question") || this.getType().equals("MultipleChoiceQuestion");
    }

    public String getSpreadsheetType() {
        return this.spreadsheetType;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public void setType(String type) {
        String tempType = type.toUpperCase();
        this.spreadsheetType = type;
        if (tempType.equals("PAGE")) {
            this.aPageElement = true;
            this.type = "Group";
            this.pageType = "Normal";
        } else if (tempType.equals("BRANCH")) {
            this.aPageElement = true;
            this.type = "Group";
            this.pageType = "Branch";
        } else {
            this.type = tempType.equalsIgnoreCase("Impact") || tempType.equalsIgnoreCase("FunctionImpact") || tempType.equalsIgnoreCase("AlternateImpact") ? "TohuDataItemObject" : type;
        }
    }

    public PageElementCondition getDisplayCondition() {
        return this.displayCondition;
    }

    public void setDisplayCondition(PageElementCondition displayCondition) {
        this.displayCondition = displayCondition;
    }

    public boolean isAGroupType() {
        return this.getType().equals("Group");
    }

    public boolean isANoteType() {
        return this.getType().equals("Note");
    }

    public boolean isAnImpactType() {
        return this.getType().equals("TohuDataItemObject");
    }

    public boolean isAPageElement() {
        return this.aPageElement;
    }

    public boolean isABranchedPage() {
        return this.aPageElement && this.pageType.equals("Branch");
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPageType() {
        return this.pageType;
    }

    public PageElement findPreviousQuestion() {
        if (this.getPreviousSibling() != null) {
            if (this.getPreviousSibling().isAQuestionType()) {
                return this.getPreviousSibling();
            }
            return this.getPreviousSibling().findPreviousQuestion();
        }
        if (this.getParent() != null) {
            if (this.getParent().isAQuestionType()) {
                return this.getParent();
            }
            return this.getParent().findPreviousQuestion();
        }
        return null;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<PageElement> getChildren() {
        return this.children;
    }

    public String getLookupTableId() {
        return this.lookupTableId;
    }

    public void setLookupTableId(String lookupTableId) {
        this.lookupTableId = lookupTableId;
    }

    public void addChild(PageElement child) {
        if (this.children.size() > 0) {
            child.setPreviousSibling(this.children.get(this.children.size() - 1));
        }
        this.children.add(child);
        child.setParent(this);
    }

    protected void setParent(PageElement parent) {
        this.parent = parent;
    }

    public PageElement getParent() {
        return this.parent;
    }

    public LookupTable getLookupTable() {
        return this.lookupTable;
    }

    public void setLookupTable(LookupTable lookupTable) {
        this.lookupTable = lookupTable;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValueStr() {
        return this.defaultValueStr;
    }

    public List<String> getStyles() {
        return this.styles;
    }

    public PageElementCondition getCurrentValidationCondition() {
        return this.currentValidationCondition;
    }

    public ConditionClause getLogicElement() {
        return this.logicElement;
    }

    public void setLogicElement(ConditionClause substituteLogicElement) {
        if (this.logicElement != null) {
            throw new IllegalArgumentException("You cannot replace the logic element");
        }
        this.logicElement = substituteLogicElement;
    }

    public void setLogicDependsOnItemId(String value) {
        if (this.logicElement == null) {
            this.logicElement = new ConditionClause();
        }
        this.logicElement.setItemId(value);
    }

    public void setLogicAttribute(String value) {
        if (this.logicElement == null) {
            this.logicElement = new ConditionClause();
        }
        this.logicElement.setItemAttribute(value);
    }

    public void setLogicOperation(String value) {
        if (this.logicElement == null) {
            this.logicElement = new ConditionClause();
        }
        this.logicElement.setOperation(value);
    }

    public void setLogicValue(String value) {
        if (this.logicElement == null) {
            this.logicElement = new ConditionClause();
        }
        this.logicElement.setValue(value);
    }

    public void addGroupId(String groupId) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<String>();
        }
        if (this.groupIds.contains(groupId)) {
            return;
        }
        this.groupIds.add(groupId);
    }

    public String getPreLabel() {
        return this.preLabel;
    }

    public void setPreLabel(String preLabel) {
        this.preLabel = preLabel;
    }

    public String getPostLabel() {
        return this.postLabel;
    }

    public void setPostLabel(String postLabel) {
        this.postLabel = postLabel;
    }

    public boolean isARepeatingElement() {
        return this.getType() != null && this.getType().equals("Reuse");
    }

    public boolean isAValidationElement() {
        return this.getType() != null && this.getType().equals("Validation");
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void setRequired(String requiredStr) {
        this.required = requiredStr != null && requiredStr.toUpperCase().startsWith("Y");
    }

    public void setDefaultValueStr(String defaultValueStr) {
        this.defaultValueStr = defaultValueStr;
    }

    public void addStyle(String style) {
        this.styles.add(style);
    }
}

