/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.domain.questionnaire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tohu.domain.questionnaire.LookupTable;
import org.tohu.domain.questionnaire.PageElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page {
    public static String PAGE_TYPE_NORMAL = "Normal";
    public static String PAGE_TYPE_BRANCH = "Branch";
    private String id;
    private String initialState;
    private String type;
    private String sheetName;
    private String label;
    private String displayAfter;
    private PageElement parentPageElement = null;
    private List<PageElement> elements = new ArrayList<PageElement>();
    private Map<String, Integer> elementLookup = new HashMap<String, Integer>();

    public Page(String sheetName, PageElement element, Page currentPage) {
        this.sheetName = sheetName;
        this.id = element.getId();
        this.initialState = element.getLogicElement() == null ? "Visible" : "Hidden";
        this.type = element.getPageType();
        this.parentPageElement = element;
        this.displayAfter = element.getPostLabel();
        element.setPostLabel(null);
        this.addElement(element);
        if (this.getDisplayAfter() == null && !this.isVisible() && currentPage != null) {
            this.setDisplayAfter(currentPage.getId());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public List<PageElement> getElements() {
        return this.elements;
    }

    public boolean isVisible() {
        return this.initialState.toUpperCase().startsWith("V");
    }

    public String getType() {
        return this.type;
    }

    public PageElement getParentPageElement() {
        return this.parentPageElement;
    }

    public String getDisplayAfter() {
        return this.displayAfter;
    }

    public void setDisplayAfter(String displayAfter) {
        this.displayAfter = displayAfter;
    }

    public boolean isBranchedPage() {
        return this.getType().equals(PAGE_TYPE_BRANCH);
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addElement(PageElement element) {
        if (element.isARepeatingElement()) {
            System.out.println("Info: ignoring request to add repeating element " + this.getId() + " to page");
            return;
        }
        if (element.getLookupTableId() != null) {
            this.elementLookup.put(element.getLookupTableId(), new Integer(this.elements.size()));
        }
        this.elementLookup.put(element.getId(), new Integer(this.elements.size()));
        this.elements.add(element);
    }

    public PageElement findElementOnThisPage(String id) {
        Integer key = this.elementLookup.get(id);
        if (key == null) {
            return null;
        }
        return this.elements.get(key);
    }

    public void assignTables(Map<String, LookupTable> tables) {
        for (PageElement pageElement : this.elements) {
            if (pageElement.getLookupTableId() == null || pageElement.getLookupTable() != null) continue;
            LookupTable table = tables.get(pageElement.getLookupTableId());
            if (table != null) {
                pageElement.setLookupTable(table);
                continue;
            }
            throw new IllegalArgumentException("No known table for " + pageElement.getLookupTableId());
        }
    }
}

