/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl17;

import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNEditor;
import org.apache.subversion.javahl.ISVNRemote;
import org.apache.subversion.javahl.ISVNReporter;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.RemoteFileRevisionsCallback;
import org.apache.subversion.javahl.callback.RemoteLocationSegmentsCallback;
import org.apache.subversion.javahl.callback.RemoteStatus;
import org.apache.subversion.javahl.remote.JavaHLRemoteAccessUtil;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.ISVNEditor2;
import org.tmatesoft.svn.core.internal.wc17.ISVNEditorProxyCallbacks;
import org.tmatesoft.svn.core.internal.wc17.SVNEditorProxy;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.javahl17.JavaHLEditorWrapper;
import org.tmatesoft.svn.core.javahl17.JavaHLReporter;
import org.tmatesoft.svn.core.javahl17.SVNClientImpl;
import org.tmatesoft.svn.util.SVNLogType;

public class JavaHLRemoteSession
implements ISVNRemote,
ISVNCanceller {
    private final SVNRepository svnRepository;
    private boolean cancelled;

    public static JavaHLRemoteSession open(SVNURL url) throws ClientException {
        try {
            SVNRepository svnRepository = SVNRepositoryFactory.create((SVNURL)url);
            return new JavaHLRemoteSession(svnRepository);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    public JavaHLRemoteSession(SVNRepository svnRepository) {
        this.svnRepository = svnRepository;
    }

    @Override
    public void dispose() {
        if (this.svnRepository != null) {
            this.svnRepository.closeSession();
        }
    }

    @Override
    public void cancelOperation() throws ClientException {
        this.cancelled = true;
    }

    @Override
    public void reparent(String url) throws ClientException {
        try {
            this.svnRepository.setLocation(SVNURL.parseURIEncoded((String)url), false);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public String getSessionUrl() throws ClientException {
        return this.svnRepository.getLocation().toString();
    }

    @Override
    public String getSessionRelativePath(String urlString) throws ClientException {
        try {
            SVNURL url = SVNURL.parseURIEncoded((String)urlString);
            return SVNPathUtil.getPathAsChild((String)this.svnRepository.getLocation().getPath(), (String)url.getPath());
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public String getReposRelativePath(String urlString) throws ClientException {
        try {
            SVNURL url = SVNURL.parseURIEncoded((String)urlString);
            SVNURL repositoryRoot = this.svnRepository.getRepositoryRoot(false);
            return SVNPathUtil.getPathAsChild((String)repositoryRoot.getPath(), (String)url.getPath());
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public String getReposUUID() throws ClientException {
        try {
            return this.svnRepository.getRepositoryUUID(false);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public String getReposRootUrl() throws ClientException {
        try {
            SVNURL repositoryRoot = this.svnRepository.getRepositoryRoot(false);
            return repositoryRoot.toString();
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public long getLatestRevision() throws ClientException {
        try {
            return this.svnRepository.getLatestRevision();
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public long getRevisionByDate(Date date) throws ClientException {
        try {
            return this.svnRepository.getDatedRevision(date);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public long getRevisionByTimestamp(long timestamp) throws ClientException {
        return this.getRevisionByDate(new Date(timestamp));
    }

    @Override
    public void changeRevisionProperty(long revision, String propertyName, byte[] oldValue, byte[] newValue) throws ClientException {
        try {
            this.svnRepository.setRevisionPropertyValue(revision, propertyName, SVNPropertyValue.create((String)propertyName, (byte[])newValue));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public Map<String, byte[]> getRevisionProperties(long revision) throws ClientException {
        try {
            SVNProperties revisionProperties = this.svnRepository.getRevisionProperties(revision, null);
            return SVNClientImpl.getProperties(revisionProperties);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public byte[] getRevisionProperty(long revision, String propertyName) throws ClientException {
        try {
            SVNPropertyValue propertyValue = this.svnRepository.getRevisionPropertyValue(revision, propertyName);
            return SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)propertyValue);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public ISVNEditor getCommitEditor(Map<String, byte[]> revisionProperties, CommitCallback commitCallback, Set<Lock> lockTokens, boolean keepLocks, ISVNEditor.ProvideBaseCallback getBase, ISVNEditor.ProvidePropsCallback getProps, ISVNEditor.GetNodeKindCallback getCopyfromKind) throws ClientException {
        throw new UnsupportedOperationException("Editor V2 is not supported");
    }

    @Override
    public ISVNEditor getCommitEditor(Map<String, byte[]> revisionProperties, CommitCallback commitCallback, Set<Lock> lockTokens, boolean keepLocks) throws ClientException {
        throw new UnsupportedOperationException("Editor V2 is not supported");
    }

    @Override
    public long getFile(long revision, String path, OutputStream contents, Map<String, byte[]> properties) throws ClientException {
        long fileRevision;
        SVNProperties svnProperties = new SVNProperties();
        try {
            fileRevision = this.svnRepository.getFile(path, revision, svnProperties, contents);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
        if (properties != null) {
            properties.putAll(SVNClientImpl.getProperties(svnProperties));
        }
        return fileRevision;
    }

    @Override
    public long getDirectory(long revision, String path, int direntFields, final Map<String, DirEntry> dirents, Map<String, byte[]> properties) throws ClientException {
        long fileRevision;
        SVNProperties svnProperties = new SVNProperties();
        try {
            final String reposRelativePath = this.getRepositoryRelativePath(path);
            fileRevision = this.svnRepository.getDir(path, revision, svnProperties, direntFields, new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    dirents.put(dirEntry.getRelativePath(), SVNClientImpl.getDirEntry(dirEntry, reposRelativePath));
                }
            });
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
        if (properties != null) {
            properties.putAll(SVNClientImpl.getProperties(svnProperties));
        }
        return fileRevision;
    }

    @Override
    public Map<String, Mergeinfo> getMergeinfo(Iterable<String> paths, long revision, Mergeinfo.Inheritance inherit, boolean includeDescendants) throws ClientException {
        try {
            Map mergeInfo = this.svnRepository.getMergeInfo(SVNClientImpl.getStrings(paths), revision, SVNClientImpl.getMergeInfoInheritance(inherit), includeDescendants);
            return SVNClientImpl.getMergeInfo(mergeInfo);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public ISVNReporter status(final String statusTarget, final long revision, final Depth depth, RemoteStatus receiver) throws ClientException {
        ISVNEditor editor = JavaHLRemoteAccessUtil.remoteStatusCallbackAsEditor(receiver);
        JavaHLEditorWrapper editor2 = new JavaHLEditorWrapper(editor);
        final SVNEditorProxy svnEditor = new SVNEditorProxy((ISVNEditor2)editor2, ISVNEditorProxyCallbacks.DUMMY);
        try {
            svnEditor.setRepositoryRoot(this.svnRepository.getRepositoryRoot(false));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
        return new JavaHLReporter(){

            @Override
            public long finishReport() throws ClientException {
                try {
                    JavaHLRemoteSession.this.svnRepository.status(revision, statusTarget, SVNClientImpl.getDepth(depth), this.getReporter(), (org.tmatesoft.svn.core.io.ISVNEditor)svnEditor);
                    return -1L;
                }
                catch (SVNException e) {
                    throw ClientException.fromException(e);
                }
            }
        };
    }

    @Override
    public void getLog(Iterable<String> paths, long startRevision, long endRevision, int limit, boolean strictNodeHistory, boolean discoverPath, boolean includeMergedRevisions, Iterable<String> revisionProperties, LogMessageCallback callback) throws ClientException {
        try {
            this.svnRepository.log(SVNClientImpl.getStrings(paths), startRevision, endRevision, discoverPath, strictNodeHistory, (long)limit, includeMergedRevisions, SVNClientImpl.getStrings(revisionProperties), SVNClientImpl.getLogEntryHandler(callback));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public NodeKind checkPath(String path, long revision) throws ClientException {
        try {
            return SVNClientImpl.getNodeKind(this.svnRepository.checkPath(path, revision));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public DirEntry stat(String path, long revision) throws ClientException {
        try {
            SVNDirEntry dirEntry = this.svnRepository.info(path, revision);
            return SVNClientImpl.getDirEntry(dirEntry, this.getRepositoryRelativePath(path));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public Map<Long, String> getLocations(String path, long pegRevision, Iterable<Long> locationRevisions) throws ClientException {
        try {
            return this.svnRepository.getLocations(path, (Map)null, pegRevision, SVNClientImpl.getLongs(locationRevisions));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public void getLocationSegments(String path, long pegRevision, long startRevision, long endRevision, RemoteLocationSegmentsCallback handler) throws ClientException {
        try {
            this.svnRepository.getLocationSegments(path, pegRevision, startRevision, endRevision, SVNClientImpl.getLocationSegmentHandler(handler));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public List<ISVNRemote.LocationSegment> getLocationSegments(String path, long pegRevision, long startRevision, long endRevision) throws ClientException {
        try {
            List locationSegments = this.svnRepository.getLocationSegments(path, pegRevision, startRevision, endRevision);
            return SVNClientImpl.getLocationSegments(locationSegments);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public void getFileRevisions(String path, long startRevision, long endRevision, boolean includeMergedRevisions, RemoteFileRevisionsCallback handler) throws ClientException {
        try {
            this.svnRepository.getFileRevisions(path, startRevision, endRevision, includeMergedRevisions, SVNClientImpl.getFileRevisionHandler(handler));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public List<ISVNRemote.FileRevision> getFileRevisions(String path, long startRevision, long endRevision, boolean includeMergedRevisions) throws ClientException {
        return null;
    }

    @Override
    public Map<String, Lock> getLocks(String path, Depth depth) throws ClientException {
        try {
            SVNLock[] locks = this.svnRepository.getLocks(path);
            return SVNClientImpl.getLocks(locks);
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    @Override
    public boolean hasCapability(ISVNRemote.Capability capability) throws ClientException {
        try {
            return this.svnRepository.hasCapability(SVNClientImpl.getCapability(capability));
        }
        catch (SVNException e) {
            throw ClientException.fromException(e);
        }
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.cancelled) {
            SVNErrorManager.cancel((String)"Cancelled.", (SVNLogType)SVNLogType.CLIENT);
        }
    }

    private String getRepositoryRelativePath(String path) throws ClientException, SVNException {
        return this.getReposRelativePath(this.svnRepository.getLocation().appendPath(path, false).toString());
    }
}

