/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.remote;

import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNEditor;
import org.apache.subversion.javahl.ISVNRemote;
import org.apache.subversion.javahl.ISVNReporter;
import org.apache.subversion.javahl.JNIObject;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.OperationContext;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.RemoteFileRevisionsCallback;
import org.apache.subversion.javahl.callback.RemoteLocationSegmentsCallback;
import org.apache.subversion.javahl.callback.RemoteStatus;
import org.apache.subversion.javahl.remote.CommitEditor;
import org.apache.subversion.javahl.remote.StateReporter;
import org.apache.subversion.javahl.remote.StatusEditor;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSession
extends JNIObject
implements ISVNRemote {
    private RemoteSessionContext sessionContext = new RemoteSessionContext();
    private WeakReference<ISVNEditor> editorReference;
    private WeakReference<ISVNReporter> reporterReference;

    @Override
    public void dispose() {
        if (this.editorReference != null) {
            ISVNEditor ed = (ISVNEditor)this.editorReference.get();
            if (ed != null) {
                ed.dispose();
                this.editorReference.clear();
            }
            this.editorReference = null;
        }
        if (this.reporterReference != null) {
            ISVNReporter rp = (ISVNReporter)this.reporterReference.get();
            if (rp != null) {
                rp.dispose();
                this.reporterReference.clear();
            }
            this.reporterReference = null;
        }
        this.nativeDispose();
    }

    @Override
    public native void cancelOperation() throws ClientException;

    @Override
    public native void reparent(String var1) throws ClientException;

    @Override
    public native String getSessionUrl() throws ClientException;

    @Override
    public native String getSessionRelativePath(String var1) throws ClientException;

    @Override
    public native String getReposRelativePath(String var1) throws ClientException;

    @Override
    public native String getReposUUID() throws ClientException;

    @Override
    public native String getReposRootUrl() throws ClientException;

    @Override
    public native long getLatestRevision() throws ClientException;

    @Override
    public long getRevisionByDate(Date date) throws ClientException {
        long timestamp = TimeUnit.MICROSECONDS.convert(date.getTime(), TimeUnit.MILLISECONDS);
        return this.getRevisionByTimestamp(timestamp);
    }

    @Override
    public native long getRevisionByTimestamp(long var1) throws ClientException;

    @Override
    public void changeRevisionProperty(long revision, String propertyName, byte[] oldValue, byte[] newValue) throws ClientException {
        if (oldValue != null && !this.hasCapability(ISVNRemote.Capability.atomic_revprops)) {
            throw new IllegalArgumentException("oldValue must be null;\nThe server does not support atomic revision property changes");
        }
        this.nativeChangeRevisionProperty(revision, propertyName, oldValue, newValue);
    }

    @Override
    public native Map<String, byte[]> getRevisionProperties(long var1) throws ClientException;

    @Override
    public native byte[] getRevisionProperty(long var1, String var3) throws ClientException;

    @Override
    public ISVNEditor getCommitEditor(Map<String, byte[]> revisionProperties, CommitCallback commitCallback, Set<Lock> lockTokens, boolean keepLocks, ISVNEditor.ProvideBaseCallback getBase, ISVNEditor.ProvidePropsCallback getProps, ISVNEditor.GetNodeKindCallback getCopyfromKind) throws ClientException {
        RemoteSession.check_inactive(this.editorReference, this.reporterReference);
        CommitEditor ed = CommitEditor.createInstance(this, revisionProperties, commitCallback, lockTokens, keepLocks, getBase, getProps, getCopyfromKind);
        if (this.editorReference != null) {
            this.editorReference.clear();
        }
        this.editorReference = new WeakReference<CommitEditor>(ed);
        return ed;
    }

    @Override
    public ISVNEditor getCommitEditor(Map<String, byte[]> revisionProperties, CommitCallback commitCallback, Set<Lock> lockTokens, boolean keepLocks) throws ClientException {
        return this.getCommitEditor(revisionProperties, commitCallback, lockTokens, keepLocks, null, null, null);
    }

    @Override
    public long getFile(long revision, String path, OutputStream contents, Map<String, byte[]> properties) throws ClientException {
        RemoteSession.maybe_clear(properties);
        return this.nativeGetFile(revision, path, contents, properties);
    }

    @Override
    public long getDirectory(long revision, String path, int direntFields, Map<String, DirEntry> dirents, Map<String, byte[]> properties) throws ClientException {
        RemoteSession.maybe_clear(dirents);
        RemoteSession.maybe_clear(properties);
        return this.nativeGetDirectory(revision, path, direntFields, dirents, properties);
    }

    @Override
    public native Map<String, Mergeinfo> getMergeinfo(Iterable<String> var1, long var2, Mergeinfo.Inheritance var4, boolean var5) throws ClientException;

    @Override
    public ISVNReporter status(String statusTarget, long revision, Depth depth, RemoteStatus receiver) throws ClientException {
        RemoteSession.check_inactive(this.editorReference, this.reporterReference);
        StateReporter rp = StateReporter.createInstance(this);
        StatusEditor editor = new StatusEditor(receiver);
        this.nativeStatus(statusTarget, revision, depth, editor, rp);
        if (this.reporterReference != null) {
            this.reporterReference.clear();
        }
        this.reporterReference = new WeakReference<StateReporter>(rp);
        return rp;
    }

    @Override
    public native void getLog(Iterable<String> var1, long var2, long var4, int var6, boolean var7, boolean var8, boolean var9, Iterable<String> var10, LogMessageCallback var11) throws ClientException;

    @Override
    public native NodeKind checkPath(String var1, long var2) throws ClientException;

    @Override
    public native DirEntry stat(String var1, long var2) throws ClientException;

    @Override
    public native Map<Long, String> getLocations(String var1, long var2, Iterable<Long> var4) throws ClientException;

    @Override
    public native void getLocationSegments(String var1, long var2, long var4, long var6, RemoteLocationSegmentsCallback var8) throws ClientException;

    @Override
    public List<ISVNRemote.LocationSegment> getLocationSegments(String path, long pegRevision, long startRevision, long endRevision) throws ClientException {
        GetLocationSegmentsHandler handler = new GetLocationSegmentsHandler();
        this.getLocationSegments(path, pegRevision, startRevision, endRevision, handler);
        return handler.locationSegments;
    }

    @Override
    public native void getFileRevisions(String var1, long var2, long var4, boolean var6, RemoteFileRevisionsCallback var7) throws ClientException;

    @Override
    public List<ISVNRemote.FileRevision> getFileRevisions(String path, long startRevision, long endRevision, boolean includeMergedRevisions) throws ClientException {
        GetFileRevisionsHandler handler = new GetFileRevisionsHandler();
        this.getFileRevisions(path, startRevision, endRevision, includeMergedRevisions, handler);
        return handler.fileRevisions;
    }

    @Override
    public native Map<String, Lock> getLocks(String var1, Depth var2) throws ClientException;

    @Override
    public boolean hasCapability(ISVNRemote.Capability capability) throws ClientException {
        return this.nativeHasCapability(capability.toString());
    }

    public native void finalize() throws Throwable;

    protected RemoteSession(long cppAddr) {
        super(cppAddr);
    }

    private native void nativeDispose();

    private native void nativeChangeRevisionProperty(long var1, String var3, byte[] var4, byte[] var5) throws ClientException;

    private native long nativeGetFile(long var1, String var3, OutputStream var4, Map<String, byte[]> var5) throws ClientException;

    private native long nativeGetDirectory(long var1, String var3, int var4, Map<String, DirEntry> var5, Map<String, byte[]> var6) throws ClientException;

    private native void nativeStatus(String var1, long var2, Depth var4, ISVNEditor var5, ISVNReporter var6) throws ClientException;

    private native boolean nativeHasCapability(String var1) throws ClientException;

    void disposeEditor(ISVNEditor editor) {
        if (this.editorReference == null) {
            return;
        }
        ISVNEditor ed = (ISVNEditor)this.editorReference.get();
        if (ed == null) {
            return;
        }
        if (ed != editor) {
            throw new IllegalStateException("Disposing unknown editor");
        }
        this.editorReference.clear();
    }

    void disposeReporter(ISVNReporter reporter) {
        if (this.reporterReference == null) {
            return;
        }
        ISVNReporter rp = (ISVNReporter)this.reporterReference.get();
        if (rp == null) {
            return;
        }
        if (rp != reporter) {
            throw new IllegalStateException("Disposing unknown reporter");
        }
        this.reporterReference.clear();
    }

    private static final <K, V> void maybe_clear(Map<K, V> clearable) {
        if (clearable != null && !clearable.isEmpty()) {
            try {
                clearable.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static final void check_inactive(WeakReference<ISVNEditor> editorReference, WeakReference<ISVNReporter> reporterReference) {
        if (editorReference != null && editorReference.get() != null) {
            throw new IllegalStateException("An editor is already active");
        }
        if (reporterReference != null && reporterReference.get() != null) {
            throw new IllegalStateException("A reporter is already active");
        }
    }

    static {
        NativeResources.loadNativeLibrary();
    }

    private class RemoteSessionContext
    extends OperationContext {
        private RemoteSessionContext() {
        }
    }

    private static class GetFileRevisionsHandler
    implements RemoteFileRevisionsCallback {
        public List<ISVNRemote.FileRevision> fileRevisions = null;

        private GetFileRevisionsHandler() {
        }

        public void doRevision(ISVNRemote.FileRevision fileRevision) {
            if (this.fileRevisions == null) {
                this.fileRevisions = new ArrayList<ISVNRemote.FileRevision>();
            }
            this.fileRevisions.add(fileRevision);
        }
    }

    private static class GetLocationSegmentsHandler
    implements RemoteLocationSegmentsCallback {
        public List<ISVNRemote.LocationSegment> locationSegments = null;

        private GetLocationSegmentsHandler() {
        }

        public void doSegment(ISVNRemote.LocationSegment locationSegment) {
            if (this.locationSegments == null) {
                this.locationSegments = new ArrayList<ISVNRemote.LocationSegment>();
            }
            this.locationSegments.add(locationSegment);
        }
    }
}

