/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.converters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.tinylog.Level;
import org.tinylog.provider.InternalLogger;

final class GzipEncoder
implements Runnable {
    static final String FILE_EXTENSION = ".gz";
    private static final int BUFFER_SIZE = 65536;
    private final File sourceFile;
    private final File targetFile;

    GzipEncoder(File file) {
        this.sourceFile = file;
        this.targetFile = new File(file.getAbsolutePath() + FILE_EXTENSION);
        try {
            if (!this.targetFile.createNewFile()) {
                InternalLogger.log((Level)Level.ERROR, (String)("Failed to pre-create file '" + this.targetFile + "'"));
            }
        }
        catch (IOException ex) {
            InternalLogger.log((Level)Level.ERROR, (Throwable)ex, (String)("Failed to pre-create file '" + this.targetFile + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.sourceFile);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.targetFile);
                try {
                    GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)fileOutputStream, 65536);
                    try {
                        int count;
                        byte[] buffer = new byte[65536];
                        while ((count = fileInputStream.read(buffer)) >= 0) {
                            gzipOutputStream.write(buffer, 0, count);
                        }
                    }
                    finally {
                        gzipOutputStream.close();
                    }
                }
                finally {
                    fileOutputStream.close();
                }
            }
            finally {
                fileInputStream.close();
            }
            if (!this.sourceFile.delete()) {
                InternalLogger.log((Level)Level.WARN, (String)("Failed to delete original log file '" + this.sourceFile + "'"));
            }
        }
        catch (IOException ex) {
            InternalLogger.log((Level)Level.ERROR, (Throwable)ex, (String)("Failed to compress log file '" + this.sourceFile + "'"));
        }
    }
}

