/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.runtime;

import java.time.Instant;
import java.util.Date;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.tinylog.runtime.Timestamp;

@IgnoreJRERequirement
public final class PreciseTimestamp
implements Timestamp {
    private static final long SECOND_IN_MILLIS = 1000L;
    private static final long MILLISECOND_IN_NANOS = 1000000L;
    private final Instant instant;

    public PreciseTimestamp() {
        this.instant = Instant.now();
    }

    public PreciseTimestamp(long milliseconds, long nanoseconds) {
        long epochSecond = milliseconds / 1000L;
        long nanoAdjustment = milliseconds % 1000L * 1000000L + nanoseconds;
        this.instant = Instant.ofEpochSecond(epochSecond, nanoAdjustment);
    }

    @Override
    public Date toDate() {
        return Date.from(this.instant);
    }

    @Override
    public Instant toInstant() {
        return this.instant;
    }

    @Override
    public java.sql.Timestamp toSqlTimestamp() {
        return java.sql.Timestamp.from(this.instant);
    }

    @Override
    public long calcDifferenceInNanoseconds(Timestamp other) {
        Instant otherInstant = other.toInstant();
        long result = this.instant.getEpochSecond() - otherInstant.getEpochSecond();
        result *= 1000000000L;
        result -= (long)otherInstant.getNano();
        return result += (long)this.instant.getNano();
    }
}

