/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.slf4j;

import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;
import org.tinylog.Level;
import org.tinylog.format.LegacyMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public abstract class AbstractTinylogLogger
implements LocationAwareLogger {
    protected static final int STACKTRACE_DEPTH = 2;
    protected static final MessageFormatter formatter = new LegacyMessageFormatter();
    protected static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    protected static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_TRACE = AbstractTinylogLogger.isCoveredByGlobalMinimumLevel(Level.TRACE);
    protected static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG = AbstractTinylogLogger.isCoveredByGlobalMinimumLevel(Level.DEBUG);
    protected static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_INFO = AbstractTinylogLogger.isCoveredByGlobalMinimumLevel(Level.INFO);
    protected static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_WARN = AbstractTinylogLogger.isCoveredByGlobalMinimumLevel(Level.WARN);
    protected static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_ERROR = AbstractTinylogLogger.isCoveredByGlobalMinimumLevel(Level.ERROR);
    protected static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_TRACE = AbstractTinylogLogger.isCoveredByDefaultMinimumLevel(Level.TRACE);
    protected static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG = AbstractTinylogLogger.isCoveredByDefaultMinimumLevel(Level.DEBUG);
    protected static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_INFO = AbstractTinylogLogger.isCoveredByDefaultMinimumLevel(Level.INFO);
    protected static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_WARN = AbstractTinylogLogger.isCoveredByDefaultMinimumLevel(Level.WARN);
    protected static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_ERROR = AbstractTinylogLogger.isCoveredByDefaultMinimumLevel(Level.ERROR);
    private final String name;

    AbstractTinylogLogger(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_TRACE && provider.isEnabled(2, null, Level.TRACE);
    }

    public void trace(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, (Object)message, (Object[])null);
        }
    }

    public void trace(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void trace(String format, Object ... arguments) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void trace(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_TRACE && provider.isEnabled(2, tag, Level.TRACE);
    }

    public void trace(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, null, null, (Object)message, (Object[])null);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void trace(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isDebugEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG && provider.isEnabled(2, null, Level.DEBUG);
    }

    public void debug(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, (Object)message, (Object[])null);
        }
    }

    public void debug(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void debug(String format, Object ... arguments) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void debug(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG && provider.isEnabled(2, tag, Level.DEBUG);
    }

    public void debug(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, null, null, (Object)message, (Object[])null);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void debug(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isInfoEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_INFO && provider.isEnabled(2, null, Level.INFO);
    }

    public void info(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, (Object)message, (Object[])null);
        }
    }

    public void info(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void info(String format, Object ... arguments) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void info(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_INFO && provider.isEnabled(2, tag, Level.INFO);
    }

    public void info(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, null, null, (Object)message, (Object[])null);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void info(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isWarnEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_WARN && provider.isEnabled(2, null, Level.WARN);
    }

    public void warn(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, (Object)message, (Object[])null);
        }
    }

    public void warn(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void warn(String format, Object ... arguments) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void warn(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_WARN && provider.isEnabled(2, tag, Level.WARN);
    }

    public void warn(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, null, null, (Object)message, (Object[])null);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void warn(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isErrorEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_ERROR && provider.isEnabled(2, null, Level.ERROR);
    }

    public void error(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, (Object)message, (Object[])null);
        }
    }

    public void error(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void error(String format, Object ... arguments) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void error(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, (Object)message, (Object[])null);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_ERROR && provider.isEnabled(2, tag, Level.ERROR);
    }

    public void error(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, null, null, (Object)message, (Object[])null);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, AbstractTinylogLogger.extractThrowable(arg), formatter, (Object)format, new Object[]{arg});
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, AbstractTinylogLogger.extractThrowable(arg2), formatter, (Object)format, new Object[]{arg1, arg2});
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, AbstractTinylogLogger.extractThrowable(arguments), formatter, (Object)format, arguments);
        }
    }

    public void error(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, exception, null, (Object)message, (Object[])null);
        }
    }

    public void log(Marker marker, String fqcn, int level, String message, Object[] arguments, Throwable exception) {
        String tag;
        Level severityLevel = AbstractTinylogLogger.translateLevel(level);
        String string = tag = marker == null ? null : marker.getName();
        if (provider.getMinimumLevel(tag).ordinal() <= severityLevel.ordinal()) {
            provider.log(fqcn, tag, severityLevel, exception, formatter, (Object)message, arguments);
        }
    }

    protected static Level translateLevel(int level) {
        if (level <= 0) {
            return Level.TRACE;
        }
        if (level <= 10) {
            return Level.DEBUG;
        }
        if (level <= 20) {
            return Level.INFO;
        }
        if (level <= 30) {
            return Level.WARN;
        }
        return Level.ERROR;
    }

    private static boolean isCoveredByGlobalMinimumLevel(Level level) {
        return provider.getMinimumLevel().ordinal() <= level.ordinal();
    }

    private static boolean isCoveredByDefaultMinimumLevel(Level level) {
        return provider.getMinimumLevel(null).ordinal() <= level.ordinal();
    }

    private static Throwable extractThrowable(Object[] arguments) {
        return arguments.length == 0 ? null : AbstractTinylogLogger.extractThrowable(arguments[arguments.length - 1]);
    }

    private static Throwable extractThrowable(Object argument) {
        return argument instanceof Throwable ? (Throwable)argument : null;
    }
}

