/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.context;

import org.springframework.context.ApplicationContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.spring6.context.IThymeleafRequestContext;
import org.thymeleaf.spring6.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring6.expression.ThymeleafEvaluationContext;

public class SpringContextUtils {
    public static final String WEB_SESSION_ATTRIBUTE_NAME = "thymeleafWebSession";
    public static final String WEB_EXCHANGE_PRINCIPAL_ATTRIBUTE_NAME = "thymeleafWebExchangePrincipal";

    public static ApplicationContext getApplicationContext(ITemplateContext context) {
        if (context == null) {
            return null;
        }
        IThymeleafEvaluationContext evaluationContext = (IThymeleafEvaluationContext)context.getVariable("thymeleaf::EvaluationContext");
        if (evaluationContext == null || !(evaluationContext instanceof ThymeleafEvaluationContext)) {
            return null;
        }
        return ((ThymeleafEvaluationContext)evaluationContext).getApplicationContext();
    }

    public static IThymeleafRequestContext getRequestContext(IExpressionContext context) {
        if (context == null) {
            return null;
        }
        return (IThymeleafRequestContext)context.getVariable("thymeleafRequestContext");
    }

    private SpringContextUtils() {
    }
}

