/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.rabbitmq;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class RabbitMQContainer
extends GenericContainer<RabbitMQContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"rabbitmq");
    private static final int DEFAULT_AMQP_PORT = 5672;
    private static final int DEFAULT_AMQPS_PORT = 5671;
    private static final int DEFAULT_HTTPS_PORT = 15671;
    private static final int DEFAULT_HTTP_PORT = 15672;
    private String adminPassword = "guest";
    private String adminUsername = "guest";
    private final List<List<String>> values = new ArrayList<List<String>>();

    public RabbitMQContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public RabbitMQContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPorts(new int[]{5672, 5671, 15672, 15671});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Server startup complete.*", (int)1));
    }

    protected void configure() {
        if (this.adminUsername != null) {
            this.addEnv("RABBITMQ_DEFAULT_USER", this.adminUsername);
        }
        if (this.adminPassword != null) {
            this.addEnv("RABBITMQ_DEFAULT_PASS", this.adminPassword);
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.values.forEach(command -> {
            try {
                Container.ExecResult execResult = this.execInContainer(command.toArray(new String[0]));
                if (execResult.getExitCode() != 0) {
                    this.logger().error("Could not execute command {}: {}", command, (Object)execResult.getStderr());
                }
            }
            catch (IOException | InterruptedException e) {
                this.logger().error("Could not execute command {}: {}", command, (Object)e.getMessage());
            }
        });
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public Integer getAmqpPort() {
        return this.getMappedPort(5672);
    }

    public Integer getAmqpsPort() {
        return this.getMappedPort(5671);
    }

    public Integer getHttpsPort() {
        return this.getMappedPort(15671);
    }

    public Integer getHttpPort() {
        return this.getMappedPort(15672);
    }

    public String getAmqpUrl() {
        return "amqp://" + this.getHost() + ":" + this.getAmqpPort();
    }

    public String getAmqpsUrl() {
        return "amqps://" + this.getHost() + ":" + this.getAmqpsPort();
    }

    public String getHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getHttpPort();
    }

    public String getHttpsUrl() {
        return "https://" + this.getHost() + ":" + this.getHttpsPort();
    }

    public RabbitMQContainer withAdminUser(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    public RabbitMQContainer withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public RabbitMQContainer withRabbitMQConfig(MountableFile rabbitMQConf) {
        return this.withRabbitMQConfigSysctl(rabbitMQConf);
    }

    public RabbitMQContainer withRabbitMQConfigSysctl(MountableFile rabbitMQConf) {
        this.withEnv("RABBITMQ_CONFIG_FILE", "/etc/rabbitmq/rabbitmq-custom.conf");
        return (RabbitMQContainer)this.withCopyFileToContainer(rabbitMQConf, "/etc/rabbitmq/rabbitmq-custom.conf");
    }

    public RabbitMQContainer withRabbitMQConfigErlang(MountableFile rabbitMQConf) {
        this.withEnv("RABBITMQ_CONFIG_FILE", "/etc/rabbitmq/rabbitmq-custom.config");
        return (RabbitMQContainer)this.withCopyFileToContainer(rabbitMQConf, "/etc/rabbitmq/rabbitmq-custom.config");
    }
}

