/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.okhttp3.internal.platform;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.testcontainers.shaded.kotlin.Metadata;
import org.testcontainers.shaded.kotlin.collections.CollectionsKt;
import org.testcontainers.shaded.kotlin.jvm.JvmStatic;
import org.testcontainers.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import org.testcontainers.shaded.kotlin.jvm.internal.Intrinsics;
import org.testcontainers.shaded.kotlin.jvm.internal.SourceDebugExtension;
import org.testcontainers.shaded.okhttp3.OkHttpClient;
import org.testcontainers.shaded.okhttp3.Protocol;
import org.testcontainers.shaded.okhttp3.internal._UtilJvmKt;
import org.testcontainers.shaded.okhttp3.internal.platform.PlatformRegistry;
import org.testcontainers.shaded.okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import org.testcontainers.shaded.okhttp3.internal.tls.BasicCertificateChainCleaner;
import org.testcontainers.shaded.okhttp3.internal.tls.BasicTrustRootIndex;
import org.testcontainers.shaded.okhttp3.internal.tls.CertificateChainCleaner;
import org.testcontainers.shaded.okhttp3.internal.tls.TrustRootIndex;
import org.testcontainers.shaded.okio.Buffer;
import org.testcontainers.shaded.org.jetbrains.annotations.NotNull;
import org.testcontainers.shaded.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0011\u0010\u0012\u001a\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J&\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020\u001f2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020\u0005H\u0016J\u001a\u0010)\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00052\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010/\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u00100\u001a\u00020\u0005H\u0016\u00a8\u00062"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/platform/Platform;", "", "<init>", "()V", "getPrefix", "", "newSSLContext", "Ljavax/net/ssl/SSLContext;", "platformTrustManager", "Ljavax/net/ssl/X509TrustManager;", "trustManager", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "protocols", "", "Lorg/testcontainers/shaded/okhttp3/Protocol;", "Lorg/testcontainers/shaded/kotlin/jvm/JvmSuppressWildcards;", "afterHandshake", "getSelectedProtocol", "getHandshakeServerNames", "connectSocket", "socket", "Ljava/net/Socket;", "address", "Ljava/net/InetSocketAddress;", "connectTimeout", "", "log", "message", "level", "t", "", "isCleartextTrafficPermitted", "", "getStackTraceForCloseable", "closer", "logCloseableLeak", "stackTrace", "buildCertificateChainCleaner", "Lorg/testcontainers/shaded/okhttp3/internal/tls/CertificateChainCleaner;", "buildTrustRootIndex", "Lorg/testcontainers/shaded/okhttp3/internal/tls/TrustRootIndex;", "newSslSocketFactory", "toString", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\nokhttp3/internal/platform/Platform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1617#2,9:242\n1869#2:251\n1870#2:253\n1626#2:254\n1#3:252\n*S KotlinDebug\n*F\n+ 1 Platform.kt\nokhttp3/internal/platform/Platform\n*L\n134#1:242,9\n134#1:251\n134#1:253\n134#1:254\n134#1:252\n*E\n"})
public class Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static volatile Platform platform = org.testcontainers.shaded.okhttp3.internal.platform.Platform$Companion.access$findPlatform(Companion);
    public static final int INFO = 4;
    public static final int WARN = 5;
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    @NotNull
    public final String getPrefix() {
        return "OkHttp";
    }

    @NotNull
    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(...)");
        return sSLContext;
    }

    @NotNull
    public X509TrustManager platformTrustManager() {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        Object[] objectArray = factory.getTrustManagers();
        Intrinsics.checkNotNull(objectArray);
        Object[] trustManagers = objectArray;
        if (!(trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected default trust managers: ");
            String string = Arrays.toString(trustManagers);
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalStateException(string2.toString());
        }
        TrustManager trustManager = trustManagers[0];
        Intrinsics.checkNotNull(trustManager, "null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        return (X509TrustManager)trustManager;
    }

    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        X509TrustManager x509TrustManager;
        Intrinsics.checkNotNullParameter(sslSocketFactory, "sslSocketFactory");
        try {
            Class<?> sslContextClass = Class.forName("sun.security.ssl.SSLContextImpl");
            Intrinsics.checkNotNull(sslContextClass);
            Object obj = _UtilJvmKt.readFieldOrNull(sslSocketFactory, sslContextClass, "context");
            if (obj == null) {
                return null;
            }
            Object context = obj;
            x509TrustManager = _UtilJvmKt.readFieldOrNull(context, X509TrustManager.class, "trustManager");
        }
        catch (ClassNotFoundException e) {
            x509TrustManager = null;
        }
        catch (RuntimeException e) {
            if (!Intrinsics.areEqual(e.getClass().getName(), "java.lang.reflect.InaccessibleObjectException")) {
                throw e;
            }
            x509TrustManager = null;
        }
        return x509TrustManager;
    }

    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<Protocol> protocols) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(protocols, "protocols");
    }

    public void afterHandshake(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
    }

    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @IgnoreJRERequirement
    @NotNull
    public List<String> getHandshakeServerNames(@NotNull SSLSocket sslSocket) {
        List list;
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        SSLSession sSLSession = sslSocket.getSession();
        ExtendedSSLSession extendedSSLSession = sSLSession instanceof ExtendedSSLSession ? (ExtendedSSLSession)sSLSession : null;
        if (extendedSSLSession == null) {
            return CollectionsKt.emptyList();
        }
        ExtendedSSLSession session = extendedSSLSession;
        try {
            void $this$mapNotNullTo$iv$iv;
            List<SNIServerName> list2 = session.getRequestedServerNames();
            Intrinsics.checkNotNullExpressionValue(list2, "getRequestedServerNames(...)");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                SNIServerName it = (SNIServerName)element$iv$iv;
                boolean bl2 = false;
                SNIHostName sNIHostName = it instanceof SNIHostName ? (SNIHostName)it : null;
                if ((sNIHostName != null ? sNIHostName.getAsciiName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (UnsupportedOperationException uoe) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public void connectSocket(@NotNull Socket socket, @NotNull InetSocketAddress address, int connectTimeout) throws IOException {
        Intrinsics.checkNotNullParameter(socket, "socket");
        Intrinsics.checkNotNullParameter(address, "address");
        socket.connect(address, connectTimeout);
    }

    public void log(@NotNull String message, int level, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter(message, "message");
        Level logLevel = level == 5 ? Level.WARNING : Level.INFO;
        logger.log(logLevel, message, t);
    }

    public static /* synthetic */ void log$default(Platform platform, String string, int n, Throwable throwable, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        platform.log(string, n, throwable);
    }

    public boolean isCleartextTrafficPermitted(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        return true;
    }

    @Nullable
    public Object getStackTraceForCloseable(@NotNull String closer) {
        Intrinsics.checkNotNullParameter(closer, "closer");
        return logger.isLoggable(Level.FINE) ? new Throwable(closer) : null;
    }

    public void logCloseableLeak(@NotNull String message, @Nullable Object stackTrace) {
        Intrinsics.checkNotNullParameter(message, "message");
        String logMessage = message;
        if (stackTrace == null) {
            logMessage = logMessage + " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);";
        }
        this.log(logMessage, 5, (Throwable)stackTrace);
    }

    @NotNull
    public CertificateChainCleaner buildCertificateChainCleaner(@NotNull X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter(trustManager, "trustManager");
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(trustManager));
    }

    @NotNull
    public TrustRootIndex buildTrustRootIndex(@NotNull X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter(trustManager, "trustManager");
        X509Certificate[] x509CertificateArray = trustManager.getAcceptedIssuers();
        return new BasicTrustRootIndex(Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
    }

    @NotNull
    public SSLSocketFactory newSslSocketFactory(@NotNull X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter(trustManager, "trustManager");
        try {
            SSLContext sSLContext;
            SSLContext $this$newSslSocketFactory_u24lambda_u240 = sSLContext = this.newSSLContext();
            boolean bl = false;
            TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
            $this$newSslSocketFactory_u24lambda_u240.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "getSocketFactory(...)");
            return sSLSocketFactory;
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError("No System TLS: " + e, e);
        }
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "getSimpleName(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Platform get() {
        return Companion.get();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\u0005H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0004\u001a\u00020\u0005J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\b\u0010\u0017\u001a\u00020\u0005H\u0002J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/platform/Platform$Companion;", "", "<init>", "()V", "platform", "Lorg/testcontainers/shaded/okhttp3/internal/platform/Platform;", "INFO", "", "WARN", "logger", "Ljava/util/logging/Logger;", "org.testcontainers.shaded.kotlin.jvm.PlatformType", "get", "resetForTests", "", "alpnProtocolNames", "", "", "protocols", "Lorg/testcontainers/shaded/okhttp3/Protocol;", "isAndroid", "", "()Z", "findPlatform", "concatLengthPrefixed", "", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\nokhttp3/internal/platform/Platform$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n774#2:242\n865#2,2:243\n1563#2:245\n1634#2,3:246\n*S KotlinDebug\n*F\n+ 1 Platform.kt\nokhttp3/internal/platform/Platform$Companion\n*L\n219#1:242\n219#1:243,2\n219#1:245\n219#1:246,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Platform get() {
            return platform;
        }

        public final void resetForTests(@NotNull Platform platform) {
            Intrinsics.checkNotNullParameter(platform, "platform");
            Platform.platform = platform;
            PublicSuffixDatabase.Companion.resetForTests$okhttp();
        }

        public static /* synthetic */ void resetForTests$default(Companion companion, Platform platform, int n, Object object) {
            if ((n & 1) != 0) {
                platform = companion.findPlatform();
            }
            companion.resetForTests(platform);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> alpnProtocolNames(@NotNull List<? extends Protocol> protocols) {
            void $this$mapTo$iv$iv;
            Protocol it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(protocols, "protocols");
            Iterable $this$filter$iv = protocols;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Protocol)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != Protocol.HTTP_1_0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Protocol)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            return (List)destination$iv$iv;
        }

        public final boolean isAndroid() {
            return PlatformRegistry.INSTANCE.isAndroid();
        }

        private final Platform findPlatform() {
            return PlatformRegistry.INSTANCE.findPlatform();
        }

        @NotNull
        public final byte[] concatLengthPrefixed(@NotNull List<? extends Protocol> protocols) {
            Intrinsics.checkNotNullParameter(protocols, "protocols");
            Buffer result = new Buffer();
            for (String protocol : this.alpnProtocolNames(protocols)) {
                result.writeByte(protocol.length());
                result.writeUtf8(protocol);
            }
            return result.readByteArray();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Platform access$findPlatform(Companion $this) {
            return $this.findPlatform();
        }
    }
}

